/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cdi.transaction;

import java.lang.annotation.Annotation;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionScoped;
import javax.transaction.TransactionSynchronizationRegistry;
import org.glassfish.cdi.transaction.TransactionScopedBean;

public class TransactionScopedContextImpl
implements Context {
    private static final String TRANSACTION_SYNCHRONIZATION_REGISTRY_JNDI_NAME = "java:comp/TransactionSynchronizationRegistry";

    public Class<? extends Annotation> getScope() {
        return TransactionScoped.class;
    }

    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        TransactionSynchronizationRegistry transactionSynchronizationRegistry = this.getTransactionSynchronizationRegistry();
        Object beanId = this.getContextualId(contextual);
        T contextualInstance = this.getContextualInstance(beanId, transactionSynchronizationRegistry);
        if (contextualInstance == null) {
            contextualInstance = this.createContextualInstance(contextual, beanId, creationalContext, transactionSynchronizationRegistry);
        }
        return contextualInstance;
    }

    public <T> T get(Contextual<T> contextual) {
        TransactionSynchronizationRegistry transactionSynchronizationRegistry = this.getTransactionSynchronizationRegistry();
        Object beanKey = this.getContextualId(contextual);
        return this.getContextualInstance(beanKey, transactionSynchronizationRegistry);
    }

    public boolean isActive() {
        try {
            if (this.getTransactionSynchronizationRegistry() != null) {
                return true;
            }
        }
        catch (ContextNotActiveException contextNotActiveException) {
            // empty catch block
        }
        return false;
    }

    private Object getContextualId(Contextual<?> contextual) {
        if (contextual instanceof PassivationCapable) {
            PassivationCapable passivationCapable = (PassivationCapable)contextual;
            return passivationCapable.getId();
        }
        return contextual;
    }

    private <T> T createContextualInstance(Contextual<T> contextual, Object contextualId, CreationalContext<T> creationalContext, TransactionSynchronizationRegistry transactionSynchronizationRegistry) {
        TransactionScopedBean<T> transactionScopedBean = new TransactionScopedBean<T>(contextual, creationalContext);
        transactionSynchronizationRegistry.putResource(contextualId, transactionScopedBean);
        transactionSynchronizationRegistry.registerInterposedSynchronization(transactionScopedBean);
        return transactionScopedBean.getContextualInstance();
    }

    private <T> T getContextualInstance(Object beanId, TransactionSynchronizationRegistry transactionSynchronizationRegistry) {
        Object obj = transactionSynchronizationRegistry.getResource(beanId);
        TransactionScopedBean transactionScopedBean = (TransactionScopedBean)obj;
        if (transactionScopedBean != null) {
            return transactionScopedBean.getContextualInstance();
        }
        return null;
    }

    private TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        TransactionSynchronizationRegistry transactionSynchronizationRegistry;
        try {
            InitialContext initialContext = new InitialContext();
            transactionSynchronizationRegistry = (TransactionSynchronizationRegistry)initialContext.lookup(TRANSACTION_SYNCHRONIZATION_REGISTRY_JNDI_NAME);
        }
        catch (NamingException ne) {
            throw new ContextNotActiveException("Could not get TransactionSynchronizationRegistry", (Throwable)ne);
        }
        int status = transactionSynchronizationRegistry.getTransactionStatus();
        if (status == 0 || status == 1 || status == 2 || status == 5 || status == 7 || status == 8 || status == 9) {
            return transactionSynchronizationRegistry;
        }
        throw new ContextNotActiveException("TransactionSynchronizationRegistry status is not active.");
    }
}

