/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cdi.transaction;

import com.sun.logging.LogDomains;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.transaction.Transaction;
import javax.transaction.Transactional;
import javax.transaction.TransactionalException;
import org.glassfish.cdi.transaction.TransactionalInterceptorBase;

@Priority(value=200)
@Interceptor
@Transactional(value=Transactional.TxType.REQUIRES_NEW)
public class TransactionalInterceptorRequiresNew
extends TransactionalInterceptorBase {
    private static Logger _logger = LogDomains.getLogger(TransactionalInterceptorRequiresNew.class, (String)"javax.enterprise.resource.jta");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object transactional(InvocationContext ctx) throws Exception {
        _logger.info("In REQUIRES_NEW TransactionalInterceptor");
        if (this.isLifeCycleMethod(ctx)) {
            return this.proceed(ctx);
        }
        this.setTransactionalTransactionOperationsManger(false);
        try {
            Transaction suspendedTransaction = null;
            if (this.getTransactionManager().getTransaction() != null) {
                _logger.info("Managed bean with Transactional annotation and TxType of REQUIRES_NEW called inside a transaction context.  Suspending before beginning a transaction...");
                suspendedTransaction = this.getTransactionManager().suspend();
            }
            try {
                this.getTransactionManager().begin();
            }
            catch (Exception exception) {
                String messageString = "Managed bean with Transactional annotation and TxType of REQUIRES_NEW encountered exception during begin " + exception;
                _logger.info(messageString);
                throw new TransactionalException(messageString, (Throwable)exception);
            }
            Object proceed = null;
            try {
                proceed = this.proceed(ctx);
            }
            finally {
                try {
                    this.getTransactionManager().commit();
                }
                catch (Exception exception) {
                    String messageString = "Managed bean with Transactional annotation and TxType of REQUIRES_NEW encountered exception during commit " + exception;
                    _logger.info(messageString);
                    throw new TransactionalException(messageString, (Throwable)exception);
                }
                if (suspendedTransaction != null) {
                    try {
                        this.getTransactionManager().resume(suspendedTransaction);
                    }
                    catch (Exception exception) {
                        String messageString = "Managed bean with Transactional annotation and TxType of REQUIRED encountered exception during resume " + exception;
                        _logger.info(messageString);
                        throw new TransactionalException(messageString, (Throwable)exception);
                    }
                }
            }
            Object object = proceed;
            return object;
        }
        finally {
            this.resetTransactionOperationsManager();
        }
    }
}

