/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Binding;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.naming.NamingContextBindingsEnumeration;
import org.apache.naming.NamingContextEnumeration;
import org.apache.naming.NamingEntry;
import org.apache.naming.Util;
import org.apache.naming.resources.BaseDirContext;
import org.apache.naming.resources.Resource;
import org.apache.naming.resources.ResourceAttributes;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.glassfish.logging.annotation.LogMessagesResourceBundle;
import org.glassfish.logging.annotation.LoggerInfo;

public class FileDirContext
extends BaseDirContext {
    @LogMessagesResourceBundle
    public static final String SHARED_LOGMESSAGE_RESOURCE = "org.apache.naming.resources.LogMessages";
    @LoggerInfo(subsystem="WEB", description="WEB Naming Logger", publish=true)
    public static final String WEB_NAMING_LOGGER = "javax.enterprise.web.naming";
    public static final Logger logger = Logger.getLogger("javax.enterprise.web.naming", "org.apache.naming.resources.LogMessages");
    public static final ResourceBundle rb = logger.getResourceBundle();
    @LogMessageInfo(message="Canonical Pathname cannot be null", level="FINE")
    private static final String FILE_RESOURCES_NULL_CANONICAL_PATH = "AS-WEB-NAMING-00001";
    @LogMessageInfo(message="Outside webapp not allowed {0} {1} {2}", level="FINE")
    private static final String FILE_RESOURCES_NOT_ALLOWED = "AS-WEB-NAMING-00002";
    @LogMessageInfo(message="Absolute Pathname cannot be null {0} {1}", level="FINE")
    private static final String FILE_RESOURCES_NULL_ABS_PATH = "AS-WEB-NAMING-00003";
    @LogMessageInfo(message="Canonical pathname {0} equals to absolute pathname {1} {2}", level="FINE")
    private static final String FILE_RESOURCES_PATH_EQUALS_ABS_PATH = "AS-WEB-NAMING-00004";
    @LogMessageInfo(message="File cannot be read {0}", level="FINE")
    private static final String FILE_RESOURCES_NOT_EXIST = "AS-WEB-NAMING-00005";
    @LogMessageInfo(message="Could not get dir listing for {0}", level="WARNING", cause="Some IO error occurred such as bad file permissions", action="Verify the file descriptors")
    private static final String FILE_RESOURCES_LISTING_NULL = "AS-WEB-NAMING-00006";
    @LogMessageInfo(message="Document base {0} does not exist or is not a readable directory", level="INFO")
    private static final String FILE_RESOURCES_BASE = "AS-WEB-NAMING-00007";
    @LogMessageInfo(message="Document base cannot be null", level="INFO")
    protected static final String RESOURCES_NULL = "AS-WEB-NAMING-00008";
    @LogMessageInfo(message="Resource {0} not found", level="INFO")
    protected static final String RESOURCES_NOT_FOUND = "AS-WEB-NAMING-00009";
    @LogMessageInfo(message="Name {0} is already bound in this Context", level="INFO")
    private static final String RESOURCES_ALREADY_BOUND = "AS-WEB-NAMING-00010";
    @LogMessageInfo(message="Bind failed: {0}", level="INFO")
    private static final String RESOURCES_BIND_FAILED = "AS-WEB-NAMING-00011";
    @LogMessageInfo(message="Unbind failed: {0}", level="INFO")
    private static final String RESOURCES_UNBIND_FAILED = "AS-WEB-NAMING-00012";
    @LogMessageInfo(message="Failed to rename [{0}] to [{1}]", level="INFO")
    private static final String RESOURCES_RENAME_FAIL = "AS-WEB-NAMING-00013";
    protected static final int BUFFER_SIZE = 2048;
    protected File base = null;
    protected Map<String, File> docBaseFileCache = Collections.synchronizedMap(new WeakHashMap());
    protected Map<String, File> fileCache = Collections.synchronizedMap(new WeakHashMap());
    protected Map<String, File> listFileCache = Collections.synchronizedMap(new WeakHashMap());
    protected String absoluteBase = null;
    protected boolean caseSensitive = true;
    protected boolean allowLinking = false;

    public FileDirContext() {
    }

    public FileDirContext(Hashtable<String, Object> env) {
        super(env);
    }

    @Override
    public void setDocBase(String docBase) {
        if (docBase == null) {
            throw new IllegalArgumentException(rb.getString(RESOURCES_NULL));
        }
        this.base = this.docBaseFileCache.get(docBase);
        if (this.base == null) {
            this.base = new File(docBase);
            this.docBaseFileCache.put(docBase, this.base);
        }
        try {
            this.base = this.base.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!(this.base.exists() && this.base.isDirectory() && this.base.canRead())) {
            throw new IllegalArgumentException(MessageFormat.format(rb.getString(FILE_RESOURCES_BASE), docBase));
        }
        this.absoluteBase = this.base.getAbsolutePath();
        super.setDocBase(docBase);
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setAllowLinking(boolean allowLinking) {
        this.allowLinking = allowLinking;
    }

    public boolean getAllowLinking() {
        return this.allowLinking;
    }

    @Override
    public void release() {
        this.caseSensitive = true;
        this.allowLinking = false;
        this.absoluteBase = null;
        this.base = null;
        super.release();
    }

    @Override
    public Object lookup(String name) throws NamingException {
        Object result = null;
        File file = this.file(name);
        if (file == null) {
            throw new NamingException(MessageFormat.format(rb.getString(RESOURCES_NOT_FOUND), name));
        }
        if (file.isDirectory()) {
            FileDirContext tempContext = new FileDirContext(this.env);
            tempContext.setDocBase(file.getPath());
            tempContext.setAllowLinking(this.getAllowLinking());
            tempContext.setCaseSensitive(this.isCaseSensitive());
            result = tempContext;
        } else {
            result = new FileResource(file);
        }
        return result;
    }

    @Override
    public void unbind(String name) throws NamingException {
        File file = this.file(name);
        if (file == null) {
            throw new NameNotFoundException(MessageFormat.format(rb.getString(RESOURCES_NOT_FOUND), name));
        }
        this.fileCache.remove(name);
        if (!file.delete()) {
            throw new NamingException(MessageFormat.format(rb.getString(RESOURCES_NOT_FOUND), name));
        }
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        File file = this.file(oldName);
        if (file == null) {
            throw new NamingException(MessageFormat.format(rb.getString(RESOURCES_NOT_FOUND), oldName));
        }
        File newFile = this.fileCache.get(newName);
        if (newFile == null) {
            newFile = new File(this.base, newName);
        }
        if (!file.renameTo(newFile)) {
            throw new NamingException(MessageFormat.format(rb.getString(RESOURCES_RENAME_FAIL), oldName, newName));
        }
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        File file = this.file(name);
        if (file == null) {
            throw new NamingException(MessageFormat.format(rb.getString(RESOURCES_NOT_FOUND), name));
        }
        return new NamingContextEnumeration(this.list(file).iterator());
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        File file = this.file(name);
        if (file == null) {
            throw new NamingException(MessageFormat.format(rb.getString(RESOURCES_NOT_FOUND), name));
        }
        return new NamingContextBindingsEnumeration(this.list(file).iterator(), this);
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.unbind(name);
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this.docBase;
    }

    @Override
    public Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        File file = this.file(name);
        if (file == null) {
            throw new NamingException(MessageFormat.format(rb.getString(RESOURCES_NOT_FOUND), name));
        }
        return new FileResourceAttributes(file);
    }

    @Override
    public void modifyAttributes(String name, int mod_op, Attributes attrs) throws NamingException {
    }

    @Override
    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
    }

    @Override
    public void bind(String name, Object obj, Attributes attrs) throws NamingException {
        File file = new File(this.base, name);
        if (file.exists()) {
            throw new NameAlreadyBoundException(MessageFormat.format(rb.getString(RESOURCES_ALREADY_BOUND), name));
        }
        this.rebind(file, obj, attrs);
    }

    @Override
    public void rebind(String name, Object obj, Attributes attrs) throws NamingException {
        File file = new File(this.base, name);
        this.rebind(file, obj, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebind(File file, Object obj, Attributes attrs) throws NamingException {
        InputStream is = null;
        String name = file.getName();
        if (obj instanceof Resource) {
            try {
                is = ((Resource)obj).streamContent();
            }
            catch (IOException e) {}
        } else if (obj instanceof InputStream) {
            is = (InputStream)obj;
        } else if (obj instanceof DirContext) {
            if (file.exists() && !file.delete()) {
                throw new NamingException(MessageFormat.format(rb.getString(RESOURCES_BIND_FAILED), name));
            }
            if (!file.mkdir()) {
                throw new NamingException(MessageFormat.format(rb.getString(RESOURCES_BIND_FAILED), name));
            }
        }
        if (is == null) {
            throw new NamingException(MessageFormat.format(rb.getString(RESOURCES_BIND_FAILED), name));
        }
        try {
            FileOutputStream os = null;
            byte[] buffer = new byte[2048];
            int len = -1;
            try {
                os = new FileOutputStream(file);
                while ((len = is.read(buffer)) != -1) {
                    os.write(buffer, 0, len);
                }
            }
            finally {
                if (os != null) {
                    os.close();
                }
                is.close();
            }
        }
        catch (IOException e) {
            throw new NamingException(MessageFormat.format(rb.getString(RESOURCES_BIND_FAILED), e));
        }
    }

    @Override
    public DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        File file = new File(this.base, name);
        if (file.exists()) {
            throw new NameAlreadyBoundException(MessageFormat.format(rb.getString(RESOURCES_ALREADY_BOUND), name));
        }
        if (!file.mkdir()) {
            throw new NamingException(MessageFormat.format(rb.getString(RESOURCES_BIND_FAILED), name));
        }
        return (DirContext)this.lookup(name);
    }

    @Override
    public DirContext getSchema(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public DirContext getSchemaClassDefinition(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        return null;
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, Attributes matchingAttributes) throws NamingException {
        return null;
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, String filter, SearchControls cons) throws NamingException {
        return null;
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        return null;
    }

    protected String normalize(String path) {
        return Util.normalize(path, File.separatorChar == '\\');
    }

    protected File file(String name) {
        return this.file(this.base, name, name, this.fileCache);
    }

    private File file(File baseFile, String name, String keyName, Map<String, File> fCache) {
        File file = fCache.get(keyName);
        if (file == null) {
            file = new File(baseFile, name);
        }
        if (file.exists() && file.canRead()) {
            if (!this.caseSensitive && this.allowLinking) {
                fCache.put(keyName, file);
                return file;
            }
            String canPath = null;
            try {
                canPath = file.getCanonicalPath();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (canPath == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, FILE_RESOURCES_NULL_CANONICAL_PATH);
                }
                return null;
            }
            if (!this.allowLinking && !canPath.startsWith(this.absoluteBase)) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, FILE_RESOURCES_NOT_ALLOWED, new Object[]{this.allowLinking, canPath, this.absoluteBase});
                }
                return null;
            }
            if (this.caseSensitive) {
                String fileAbsPath = file.getAbsolutePath();
                if (fileAbsPath.endsWith(".")) {
                    fileAbsPath = fileAbsPath + "/";
                }
                String absPath = this.normalize(fileAbsPath);
                if ((canPath = this.normalize(canPath)) == null || absPath == null) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, FILE_RESOURCES_NULL_ABS_PATH, new Object[]{canPath, absPath});
                    }
                    return null;
                }
                if (this.absoluteBase.length() < absPath.length() && this.absoluteBase.length() < canPath.length()) {
                    if ((absPath = absPath.substring(this.absoluteBase.length() + 1)).equals("")) {
                        absPath = "/";
                    }
                    if ((canPath = canPath.substring(this.absoluteBase.length() + 1)).equals("")) {
                        canPath = "/";
                    }
                    if (!(canPath.equals(absPath) || !canPath.equalsIgnoreCase(absPath) && this.allowLinking)) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, FILE_RESOURCES_PATH_EQUALS_ABS_PATH, new Object[]{canPath, absPath, this.allowLinking});
                        }
                        return null;
                    }
                }
            }
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, FILE_RESOURCES_NOT_EXIST, file.getAbsolutePath());
            }
            return null;
        }
        fCache.put(keyName, file);
        return file;
    }

    protected ArrayList<NamingEntry> list(File file) {
        ArrayList<NamingEntry> entries = new ArrayList<NamingEntry>();
        if (!file.isDirectory()) {
            return entries;
        }
        Object[] names = file.list();
        if (names == null) {
            logger.log(Level.WARNING, FILE_RESOURCES_LISTING_NULL, file.getAbsolutePath());
            return entries;
        }
        Arrays.sort(names);
        NamingEntry entry = null;
        for (int i = 0; i < names.length; ++i) {
            String keyName = file.getPath() + '/' + (String)names[i];
            File currentFile = this.file(file, (String)names[i], keyName, this.listFileCache);
            Object object = null;
            if (currentFile != null && currentFile.isDirectory()) {
                FileDirContext tempContext = new FileDirContext(this.env);
                tempContext.setDocBase(file.getPath());
                tempContext.setAllowLinking(this.getAllowLinking());
                tempContext.setCaseSensitive(this.isCaseSensitive());
                object = tempContext;
            } else {
                object = new FileResource(currentFile);
            }
            entry = new NamingEntry((String)names[i], object, 0);
            entries.add(entry);
        }
        return entries;
    }

    protected static class FileResourceAttributes
    extends ResourceAttributes {
        protected File file;
        protected boolean accessed = false;
        protected String canonicalPath = null;

        public FileResourceAttributes(File file) {
            this.file = file;
            this.getCreation();
            this.getLastModified();
        }

        @Override
        public boolean isCollection() {
            if (!this.accessed) {
                this.collection = this.file.isDirectory();
                this.accessed = true;
            }
            return super.isCollection();
        }

        @Override
        public long getContentLength() {
            if (this.contentLength != -1L) {
                return this.contentLength;
            }
            this.contentLength = this.file.length();
            return this.contentLength;
        }

        @Override
        public long getCreation() {
            if (this.creation != -1L) {
                return this.creation;
            }
            this.creation = this.getLastModified();
            return this.creation;
        }

        @Override
        public Date getCreationDate() {
            if (this.creation == -1L) {
                this.creation = this.file.lastModified();
            }
            return super.getCreationDate();
        }

        @Override
        public long getLastModified() {
            if (this.lastModified != -1L) {
                return this.lastModified;
            }
            this.lastModified = this.file.lastModified();
            return this.lastModified;
        }

        @Override
        public Date getLastModifiedDate() {
            if (this.lastModified == -1L) {
                this.lastModified = this.file.lastModified();
            }
            return super.getLastModifiedDate();
        }

        @Override
        public String getName() {
            if (this.name == null) {
                this.name = this.file.getName();
            }
            return this.name;
        }

        @Override
        public String getResourceType() {
            if (!this.accessed) {
                this.collection = this.file.isDirectory();
                this.accessed = true;
            }
            return super.getResourceType();
        }

        @Override
        public String getCanonicalPath() {
            if (this.canonicalPath == null) {
                try {
                    this.canonicalPath = this.file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return this.canonicalPath;
        }
    }

    protected static class FileResource
    extends Resource {
        protected File file;

        public FileResource(File file) {
            this.file = file;
        }

        @Override
        public InputStream streamContent() throws IOException {
            if (this.binaryContent == null) {
                FileInputStream fin = new FileInputStream(this.file);
                this.inputStream = fin;
                return fin;
            }
            return super.streamContent();
        }
    }
}

