/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import org.apache.naming.NamingServiceMBean;

public final class NamingService
extends NotificationBroadcasterSupport
implements NamingServiceMBean,
MBeanRegistration {
    private static final Logger log = Logger.getLogger(NamingService.class.getName());
    private NamingServiceMBean.State state = NamingServiceMBean.State.STOPPED;
    private long sequenceNumber = 0L;
    private String oldUrlValue = "";
    private String oldIcValue = "";

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        return new ObjectName(":service=Naming");
    }

    public void postRegister(Boolean registrationDone) {
        if (!registrationDone.booleanValue()) {
            this.destroy();
        }
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
        this.destroy();
    }

    public String getName() {
        return "Apache JNDI Naming Service";
    }

    public NamingServiceMBean.State getState() {
        return this.state;
    }

    public void start() throws Exception {
        AttributeChangeNotification notification = null;
        if (this.state != NamingServiceMBean.State.STOPPED) {
            return;
        }
        this.state = NamingServiceMBean.State.STARTING;
        notification = new AttributeChangeNotification(this, this.sequenceNumber++, System.currentTimeMillis(), "Starting Apache JNDI Naming Service", "State", "org.apache.naming.NamingServiceMBean$State", (Object)NamingServiceMBean.State.STOPPED, (Object)NamingServiceMBean.State.STARTING);
        this.sendNotification(notification);
        try {
            String value = "org.apache.naming";
            String oldValue = System.getProperty("java.naming.factory.url.pkgs");
            if (oldValue != null) {
                this.oldUrlValue = oldValue;
                value = oldValue + ":" + value;
            }
            System.setProperty("java.naming.factory.url.pkgs", value);
            oldValue = System.getProperty("java.naming.factory.initial");
            if (oldValue != null) {
                this.oldIcValue = oldValue;
            } else {
                System.setProperty("java.naming.factory.initial", "org.apache.naming.java.javaURLContextFactory");
            }
        }
        catch (Throwable t) {
            this.state = NamingServiceMBean.State.STOPPED;
            notification = new AttributeChangeNotification(this, this.sequenceNumber++, System.currentTimeMillis(), "Stopped Apache JNDI Naming Service", "State", "org.apache.naming.NamingServiceMBean$State", (Object)NamingServiceMBean.State.STARTING, (Object)NamingServiceMBean.State.STOPPED);
            this.sendNotification(notification);
        }
        this.state = NamingServiceMBean.State.STARTED;
        notification = new AttributeChangeNotification(this, this.sequenceNumber++, System.currentTimeMillis(), "Started Apache JNDI Naming Service", "State", "org.apache.naming.NamingServiceMBean$State", (Object)NamingServiceMBean.State.STARTING, (Object)NamingServiceMBean.State.STARTED);
        this.sendNotification(notification);
    }

    public void stop() {
        AttributeChangeNotification notification = null;
        if (this.state != NamingServiceMBean.State.STARTED) {
            return;
        }
        this.state = NamingServiceMBean.State.STOPPING;
        notification = new AttributeChangeNotification(this, this.sequenceNumber++, System.currentTimeMillis(), "Stopping Apache JNDI Naming Service", "State", "org.apache.naming.NamingServiceMBean$State", (Object)NamingServiceMBean.State.STARTED, (Object)NamingServiceMBean.State.STOPPING);
        this.sendNotification(notification);
        try {
            System.setProperty("java.naming.factory.url.pkgs", this.oldUrlValue);
            System.setProperty("java.naming.factory.initial", this.oldIcValue);
        }
        catch (Throwable t) {
            log.log(Level.WARNING, "Unable to restore original system properties", t);
        }
        this.state = NamingServiceMBean.State.STOPPED;
        notification = new AttributeChangeNotification(this, this.sequenceNumber++, System.currentTimeMillis(), "Stopped Apache JNDI Naming Service", "State", "org.apache.naming.NamingServiceMBean$State", (Object)NamingServiceMBean.State.STOPPING, (Object)NamingServiceMBean.State.STOPPED);
        this.sendNotification(notification);
    }

    public void destroy() {
        if (this.getState() != NamingServiceMBean.State.STOPPED) {
            this.stop();
        }
    }
}

