/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.ha.session.management;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.glassfish.ha.store.api.Storeable;
import org.glassfish.web.ha.session.management.SessionAttributeMetadata;

public final class CompositeMetadata
implements Storeable {
    private long version;
    private long maxInactiveInterval;
    private long lastAccessTime;
    private byte[] state;
    private String stringExtraParam;
    private Map<String, SessionAttributeMetadata> attributesMap = new HashMap<String, SessionAttributeMetadata>();
    private transient Collection<SessionAttributeMetadata> entries;
    private transient Set<String> _dirtyAttributeNames = new HashSet<String>();
    private static transient String[] _attributeNames = new String[]{"trunkState", "stringExtraParam", "sessionAttributes"};
    private static transient Set<String> saveALL = new HashSet<String>();
    private static transient Set<String> saveEP = new HashSet<String>();
    private boolean[] dirtyBits = new boolean[]{false, false, false};

    public CompositeMetadata() {
    }

    public CompositeMetadata(long version, long lastAccessTime, long maxInactiveInterval, Collection<SessionAttributeMetadata> entries, byte[] state, String stringExtraParam) {
        this.version = version;
        this.lastAccessTime = lastAccessTime;
        this.maxInactiveInterval = maxInactiveInterval;
        this.entries = entries;
        this.dirtyBits[2] = true;
        if (state != null) {
            this.setState(state);
        } else {
            this.dirtyBits[0] = false;
        }
        this.setStringExtraParam(stringExtraParam);
    }

    public byte[] getState() {
        return this.state;
    }

    public void setState(byte[] state) {
        this.state = state;
        this.dirtyBits[0] = true;
    }

    public String getStringExtraParam() {
        return this.stringExtraParam;
    }

    public void setStringExtraParam(String stringExtraParam) {
        this.stringExtraParam = stringExtraParam;
        this.dirtyBits[1] = true;
    }

    public Collection<SessionAttributeMetadata> getEntries() {
        return this.attributesMap.values();
    }

    public long getVersion() {
        return this.version;
    }

    public long _storeable_getVersion() {
        return this.version;
    }

    public void _storeable_setVersion(long version) {
        this.version = version;
    }

    public long _storeable_getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void _storeable_setLastAccessTime(long lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public long _storeable_getMaxIdleTime() {
        return this.maxInactiveInterval;
    }

    public void _storeable_setMaxIdleTime(long maxInactiveInterval) {
        this.maxInactiveInterval = maxInactiveInterval;
    }

    public String[] _storeable_getAttributeNames() {
        return _attributeNames;
    }

    public boolean[] _storeable_getDirtyStatus() {
        return this.dirtyBits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _storeable_writeState(OutputStream os) throws IOException {
        DataOutputStream dos = null;
        try {
            dos = new DataOutputStream(os);
            dos.writeLong(this.version);
            dos.writeLong(this.lastAccessTime);
            dos.writeLong(this.maxInactiveInterval);
            for (int i = 0; i < this.dirtyBits.length; ++i) {
                dos.writeBoolean(this.dirtyBits[i]);
            }
            if (this.dirtyBits[0]) {
                dos.writeInt(this.state == null ? 0 : this.state.length);
                if (this.state != null) {
                    dos.write(this.state);
                }
            }
            if (this.dirtyBits[1]) {
                if (this.stringExtraParam == null) {
                    dos.writeInt(0);
                } else {
                    byte[] sd = this.stringExtraParam.getBytes(Charset.defaultCharset());
                    dos.writeInt(sd.length);
                    dos.write(sd);
                }
            }
            if (this.dirtyBits[2]) {
                dos.writeInt(this.entries.size());
                for (SessionAttributeMetadata attr : this.entries) {
                    byte[] opNameInBytes = attr.getOperation().toString().getBytes(Charset.defaultCharset());
                    dos.writeInt(opNameInBytes.length);
                    dos.write(opNameInBytes);
                    String attrName = attr.getAttributeName();
                    if (attrName == null) {
                        dos.writeInt(0);
                        continue;
                    }
                    byte[] attrNameData = attrName.getBytes(Charset.defaultCharset());
                    dos.writeInt(attrNameData.length);
                    dos.write(attrNameData);
                    if (attr.getOperation() != SessionAttributeMetadata.Operation.ADD && attr.getOperation() != SessionAttributeMetadata.Operation.UPDATE) continue;
                    byte[] attrData = attr.getState();
                    if (attrData == null) {
                        dos.writeInt(0);
                        continue;
                    }
                    dos.writeInt(attrData.length);
                    dos.write(attrData);
                }
            }
        }
        finally {
            try {
                dos.flush();
                dos.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _storeable_readState(InputStream is) throws IOException {
        DataInputStream dis = null;
        try {
            int len;
            dis = new DataInputStream(is);
            this.version = dis.readLong();
            this.lastAccessTime = dis.readLong();
            this.maxInactiveInterval = dis.readLong();
            this.dirtyBits = new boolean[]{true, true, true};
            boolean[] dirtyFlags = new boolean[3];
            for (int i = 0; i < dirtyFlags.length; ++i) {
                dirtyFlags[i] = dis.readBoolean();
            }
            if (dirtyFlags[0] && (len = dis.readInt()) > 0) {
                this.state = new byte[len];
                dis.readFully(this.state);
            }
            if (dirtyFlags[1] && (len = dis.readInt()) > 0) {
                byte[] sd = new byte[len];
                dis.readFully(sd);
                this.stringExtraParam = new String(sd, Charset.defaultCharset());
            }
            if (dirtyFlags[2]) {
                int entryCount = dis.readInt();
                block12: for (int i = 0; i < entryCount; ++i) {
                    int opNameLen = dis.readInt();
                    byte[] opnameData = new byte[opNameLen];
                    dis.readFully(opnameData);
                    String opName = new String(opnameData, Charset.defaultCharset());
                    int attrNameLen = dis.readInt();
                    if (attrNameLen <= 0) continue;
                    byte[] sd = new byte[attrNameLen];
                    dis.readFully(sd);
                    String attrName = new String(sd, Charset.defaultCharset());
                    SessionAttributeMetadata.Operation smdOpcode = SessionAttributeMetadata.Operation.valueOf(opName);
                    switch (smdOpcode) {
                        case ADD: 
                        case UPDATE: {
                            int dataLen = dis.readInt();
                            byte[] attrData = new byte[dataLen];
                            dis.readFully(attrData);
                            this.attributesMap.put(attrName, new SessionAttributeMetadata(attrName, smdOpcode, attrData));
                            continue block12;
                        }
                        case DELETE: {
                            this.attributesMap.remove(attrName);
                            continue block12;
                        }
                        default: {
                            throw new IOException("Unknown operation");
                        }
                    }
                }
            }
        }
        finally {
            try {
                dis.close();
            }
            catch (Exception exception) {}
        }
    }

    public String toString() {
        return "CompositeMetadata{version=" + this.version + ", maxInactiveInterval=" + this.maxInactiveInterval + ", lastAccessTime=" + this.lastAccessTime + ", state=" + (this.state == null ? 0 : this.state.length) + ", _dirtyAttributeNames=" + this._dirtyAttributeNames + '}';
    }

    static {
        saveALL.add("state");
        saveALL.add("extraParam");
        saveEP.add("extraParam");
    }
}

