/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.ha.strategy.builder;

import com.sun.enterprise.container.common.spi.util.JavaEEIOUtils;
import com.sun.enterprise.deployment.runtime.web.SessionManager;
import com.sun.enterprise.web.BasePersistenceStrategyBuilder;
import com.sun.enterprise.web.ServerConfigLookup;
import com.sun.enterprise.web.WebModule;
import java.util.HashMap;
import javax.inject.Inject;
import org.apache.catalina.Context;
import org.apache.catalina.Store;
import org.apache.catalina.core.StandardContext;
import org.glassfish.ha.store.api.Storeable;
import org.glassfish.ha.store.util.SimpleMetadata;
import org.glassfish.web.ha.session.management.CompositeMetadata;
import org.glassfish.web.ha.session.management.FullSessionFactory;
import org.glassfish.web.ha.session.management.HASessionStoreValve;
import org.glassfish.web.ha.session.management.ModifiedAttributeSessionFactory;
import org.glassfish.web.ha.session.management.ModifiedSessionFactory;
import org.glassfish.web.ha.session.management.ReplicationAttributeStore;
import org.glassfish.web.ha.session.management.ReplicationStore;
import org.glassfish.web.ha.session.management.ReplicationWebEventPersistentManager;
import org.glassfish.web.ha.session.management.SessionFactory;
import org.glassfish.web.valve.GlassFishValve;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="replicated")
@Scoped(value=PerLookup.class)
public class ReplicatedWebMethodSessionStrategyBuilder
extends BasePersistenceStrategyBuilder {
    @Inject
    private ReplicationWebEventPersistentManager rwepMgr;
    @Inject
    private JavaEEIOUtils ioUtils;

    public void initializePersistenceStrategy(Context ctx, SessionManager smBean, ServerConfigLookup serverConfigLookup) {
        super.initializePersistenceStrategy(ctx, smBean, serverConfigLookup);
        if (this.getPersistenceScope().equals("session")) {
            this.setupReplicationWebEventPersistentManager(SimpleMetadata.class, new FullSessionFactory(), new ReplicationStore(serverConfigLookup, this.ioUtils), ctx, serverConfigLookup);
        } else if (this.getPersistenceScope().equals("modified-session")) {
            this.setupReplicationWebEventPersistentManager(SimpleMetadata.class, new ModifiedSessionFactory(), new ReplicationStore(serverConfigLookup, this.ioUtils), ctx, serverConfigLookup);
        } else if (this.getPersistenceScope().equals("modified-attribute")) {
            this.setupReplicationWebEventPersistentManager(CompositeMetadata.class, new ModifiedAttributeSessionFactory(), new ReplicationAttributeStore(serverConfigLookup, this.ioUtils), ctx, serverConfigLookup);
        } else {
            throw new IllegalArgumentException(this.getPersistenceScope());
        }
        HASessionStoreValve haValve = new HASessionStoreValve();
        StandardContext stdCtx = (StandardContext)ctx;
        stdCtx.addValve((GlassFishValve)haValve);
    }

    private <T extends Storeable> void setupReplicationWebEventPersistentManager(Class<T> metadataClass, SessionFactory sessionFactory, ReplicationStore store, Context ctx, ServerConfigLookup serverConfigLookup) {
        HashMap<String, Object> vendorMap = new HashMap<String, Object>();
        boolean asyncReplicationValue = serverConfigLookup.getAsyncReplicationFromConfig((WebModule)ctx);
        vendorMap.put("async.replication", asyncReplicationValue);
        vendorMap.put("broadcast.remove.expired", false);
        vendorMap.put("value.class.is.thread.safe", true);
        ReplicationWebEventPersistentManager<T> rwepMgr = this.getReplicationWebEventPersistentManager();
        rwepMgr.setSessionFactory(sessionFactory);
        rwepMgr.createBackingStore(this.getPassedInPersistenceType(), ctx.getPath(), metadataClass, vendorMap);
        boolean disableJreplica = serverConfigLookup.getDisableJreplicaFromConfig();
        rwepMgr.setMaxActiveSessions(this.maxSessions);
        rwepMgr.setMaxIdleBackup(0);
        rwepMgr.setRelaxCacheVersionSemantics(this.relaxCacheVersionSemantics);
        rwepMgr.setStore((Store)store);
        rwepMgr.setDisableJreplica(disableJreplica);
        ctx.setManager(rwepMgr);
        if (!((StandardContext)ctx).isSessionTimeoutOveridden()) {
            rwepMgr.setMaxInactiveInterval(this.sessionMaxInactiveInterval);
        }
    }

    private <T extends Storeable> ReplicationWebEventPersistentManager<T> getReplicationWebEventPersistentManager() {
        return this.rwepMgr;
    }
}

