/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.ha.session.management;

import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.session.PersistentManagerBase;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.ha.store.api.Storeable;
import org.glassfish.web.ha.session.management.SessionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReplicationManagerBase<T extends Storeable>
extends PersistentManagerBase {
    protected BackingStore<String, T> backingStore;
    protected SessionFactory sessionFactory;
    protected static final String name = "ReplicationManagerBase";
    protected Logger logger = LogDomains.getLogger(ReplicationManagerBase.class, (String)"javax.enterprise.system.container.web");
    protected boolean relaxCacheVersionSemantics = false;
    protected boolean disableJreplica = false;

    public BackingStore<String, T> getBackingStore() {
        return this.backingStore;
    }

    public abstract void createBackingStore(String var1, String var2, Class<T> var3, Map<String, Object> var4);

    public Session createNewSession() {
        return this.sessionFactory.createSession((Manager)this);
    }

    public Session createEmptySession() {
        Session sess = this.sessionFactory.createSession((Manager)this);
        return sess;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setBackingStore(BackingStore<String, T> backingStore) {
        this.backingStore = backingStore;
    }

    public void doRemove(String id) {
        try {
            this.backingStore.remove((Serializable)((Object)id));
        }
        catch (BackingStoreException e) {
            this.logger.warning("Failed to remove session from backing store");
        }
    }

    public boolean isSessionVersioningSupported() {
        return true;
    }

    public Session findSession(String id, String version) throws IOException {
        Session cachedSession;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("in findSession: version=" + version);
        }
        if (!this.isSessionIdValid(id) || version == null) {
            return null;
        }
        Session loadedSession = null;
        long requiredVersion = 0L;
        long cachedVersion = -1L;
        try {
            requiredVersion = Long.valueOf(version);
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Required version " + requiredVersion);
            }
        }
        catch (NumberFormatException ex) {
            this.logger.log(Level.INFO, "required version nfe ", ex);
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("findSession:requiredVersion=" + requiredVersion);
        }
        if ((cachedSession = (Session)this.sessions.get(id)) != null) {
            cachedVersion = cachedSession.getVersion();
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("findSession:cachedVersion=" + cachedVersion);
        }
        if (cachedVersion == requiredVersion || this.isRelaxCacheVersionSemantics() && cachedVersion > requiredVersion) {
            return cachedSession;
        }
        if (cachedVersion < requiredVersion && !this.isRelaxCacheVersionSemantics()) {
            this.removeSessionFromManagerCache(cachedSession);
            cachedSession = null;
            cachedVersion = -1L;
        }
        loadedSession = requiredVersion != -1L ? this.swapIn(id, version) : this.swapIn(id);
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("findSession:swappedInSession=" + loadedSession);
        }
        if (loadedSession == null || loadedSession.getVersion() < cachedVersion) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("ReplicationManagerBase>>findSession:returning cached version:" + cachedVersion);
            }
            return cachedSession;
        }
        if (loadedSession.getVersion() < requiredVersion && !this.isRelaxCacheVersionSemantics()) {
            loadedSession = null;
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("ReplicationManagerBase>>findSession:returning:" + loadedSession);
        }
        return loadedSession;
    }

    public boolean isRelaxCacheVersionSemantics() {
        return this.relaxCacheVersionSemantics;
    }

    public void setRelaxCacheVersionSemantics(boolean value) {
        this.relaxCacheVersionSemantics = value;
    }

    public void removeSessionFromManagerCache(Session session) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("in " + ((Object)((Object)this)).getClass().getName() + ">>removeSessionFromManagerCache:session = " + session);
        }
        if (session == null) {
            return;
        }
        Session removed = null;
        removed = (Session)this.sessions.remove(session.getIdInternal());
        if (removed != null && this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Remove from manager cache id=" + session.getId());
        }
    }

    public void setDisableJreplica(boolean disableJreplica) {
        this.disableJreplica = disableJreplica;
    }

    public boolean isDisableJreplica() {
        return this.disableJreplica;
    }

    public abstract void doValveSave(Session var1);

    public abstract String getReplicaFromPredictor(String var1, String var2);
}

