/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.ha.authenticator;

import com.sun.enterprise.container.common.spi.util.JavaEEIOUtils;
import com.sun.enterprise.security.web.GlassFishSingleSignOn;
import com.sun.enterprise.web.SSOFactory;
import com.sun.enterprise.web.session.PersistenceType;
import javax.inject.Inject;
import org.glassfish.gms.bootstrap.GMSAdapterService;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreConfiguration;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.ha.store.api.BackingStoreFactory;
import org.glassfish.hk2.Services;
import org.glassfish.web.ha.authenticator.HASingleSignOn;
import org.glassfish.web.ha.authenticator.HASingleSignOnEntryMetadata;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=PerLookup.class)
public class HASSOFactory
implements SSOFactory {
    private static final String STORE_NAME = "SSOStore";
    private static BackingStore<String, HASingleSignOnEntryMetadata> ssoEntryMetadataBackingStore = null;
    @Inject
    private Services services;
    @Inject
    private JavaEEIOUtils ioUtils;

    public GlassFishSingleSignOn createSingleSignOnValve(String virtualServerName) {
        String persistenceType = PersistenceType.REPLICATED.getType();
        return new HASingleSignOn(this.ioUtils, HASSOFactory.getSsoEntryMetadataBackingStore(persistenceType, STORE_NAME, this.services));
    }

    protected static synchronized BackingStore<String, HASingleSignOnEntryMetadata> getSsoEntryMetadataBackingStore(String persistenceType, String storeName, Services services) {
        if (ssoEntryMetadataBackingStore == null) {
            BackingStoreFactory factory = (BackingStoreFactory)services.forContract(BackingStoreFactory.class).named(persistenceType).get();
            BackingStoreConfiguration conf = new BackingStoreConfiguration();
            String clusterName = "";
            String instanceName = "";
            GMSAdapterService gmsAdapterService = (GMSAdapterService)services.byType(GMSAdapterService.class).get();
            if (gmsAdapterService.isGmsEnabled()) {
                clusterName = gmsAdapterService.getGMSAdapter().getClusterName();
                instanceName = gmsAdapterService.getGMSAdapter().getModule().getInstanceName();
            }
            conf.setStoreName(storeName).setClusterName(clusterName).setInstanceName(instanceName).setStoreType(persistenceType).setKeyClazz(String.class).setValueClazz(HASingleSignOnEntryMetadata.class);
            try {
                ssoEntryMetadataBackingStore = factory.createBackingStore(conf);
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        }
        return ssoEntryMetadataBackingStore;
    }
}

