/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.appserv.web.cache.CacheManager;
import com.sun.enterprise.container.common.spi.JCDIService;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.util.ComponentVisitor;
import com.sun.enterprise.deployment.web.InitializationParameter;
import com.sun.enterprise.util.net.JarURIPattern;
import com.sun.enterprise.web.CacheModule;
import com.sun.enterprise.web.WebComponentInvocation;
import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.web.WebModule;
import com.sun.enterprise.web.jsp.JspProbeEmitterImpl;
import com.sun.enterprise.web.jsp.ResourceInjectorImpl;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import org.apache.catalina.Globals;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Wrapper;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.web.TldProvider;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.loader.util.ASClassLoaderUtil;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.glassfish.web.deployment.runtime.SunWebAppImpl;
import org.glassfish.web.deployment.runtime.WebProperty;
import org.glassfish.web.deployment.util.WebValidatorWithCL;

final class WebModuleListener
implements LifecycleListener {
    private static final Logger _logger = WebContainer.logger;
    @LogMessageInfo(message="Lifecycle event data object [{0}] is not a WebModule", level="WARNING")
    public static final String CLASS_CAST_EXCEPTION = "AS-WEB-GLUE-00259";
    @LogMessageInfo(message="jsp-config property for {0} ", level="FINE")
    public static final String JSP_CONFIG_PROPERTY = "AS-WEB-GLUE-00260";
    @LogMessageInfo(message="sysClasspath for {0} ", level="FINE")
    public static final String SYS_CLASSPATH = "AS-WEB-GLUE-00261";
    @LogMessageInfo(message="Error creating cache manager and configuring the servlet caching subsystem", level="WARNING")
    public static final String CACHE_MRG_EXCEPTION = "AS-WEB-GLUE-00262";
    @LogMessageInfo(message="Cache Manager started", level="FINE")
    public static final String CACHE_MANAGER_STARTED = "AS-WEB-GLUE-00263";
    @LogMessageInfo(message="Cache Manager stopped", level="FINE")
    public static final String CACHE_MANAGER_STOPPED = "AS-WEB-GLUE-00264";
    private WebBundleDescriptor wbd;
    private WebContainer webContainer;
    private boolean includeInitialized;
    private List<String> includeJars;

    public WebModuleListener(WebContainer webContainer, WebBundleDescriptor wbd) {
        this.webContainer = webContainer;
        this.wbd = wbd;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        WebModule webModule;
        try {
            webModule = (WebModule)event.getLifecycle();
        }
        catch (ClassCastException e) {
            _logger.log(Level.WARNING, CLASS_CAST_EXCEPTION, event.getLifecycle());
            return;
        }
        if (event.getType().equals("start")) {
            if (this.wbd != null && this.wbd.getApplication() != null && this.wbd.getApplication().isVirtual()) {
                this.wbd.setClassLoader(webModule.getLoader().getClassLoader());
                this.wbd.visit((ComponentVisitor)new WebValidatorWithCL());
            }
            this.configureDefaultServlet(webModule);
            this.configureJsp(webModule);
            this.startCacheManager(webModule);
        } else if (event.getType().equals("stop")) {
            this.stopCacheManager(webModule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureJsp(WebModule webModule) {
        ServletContext servletContext = webModule.getServletContext();
        servletContext.setAttribute("org.glassfish.jsp.isStandaloneWebapp", (Object)webModule.isStandalone());
        List<URI> appLibUris = webModule.getDeployAppLibs();
        HashMap<URI, List> appLibTldMap = new HashMap<URI, List>();
        if (appLibUris != null && appLibUris.size() > 0) {
            Pattern pattern = Pattern.compile("META-INF/.*\\.tld");
            for (URI uri : appLibUris) {
                List entries = JarURIPattern.getJarEntries((URI)uri, (Pattern)pattern);
                if (entries == null || entries.size() <= 0) continue;
                appLibTldMap.put(uri, entries);
            }
        }
        Collection<TldProvider> tldProviders = this.webContainer.getTldProviders();
        HashMap<URI, List> tldMap = new HashMap<URI, List>();
        for (TldProvider tldProvider : tldProviders) {
            Map tmap;
            if ("jsfTld".equals(tldProvider.getName()) && !webModule.isJsfApplication() || (tmap = tldProvider.getTldMap()) == null) continue;
            tldMap.putAll(tmap);
        }
        tldMap.putAll(appLibTldMap);
        servletContext.setAttribute("com.sun.appserv.tld.map", tldMap);
        HashMap<URI, List> tldListenerMap = new HashMap<URI, List>();
        for (TldProvider tldProvider : tldProviders) {
            Map tmap;
            if ("jsfTld".equals(tldProvider.getName()) && !webModule.isJsfApplication() || (tmap = tldProvider.getTldListenerMap()) == null) continue;
            tldListenerMap.putAll(tmap);
        }
        tldListenerMap.putAll(appLibTldMap);
        servletContext.setAttribute("com.sun.appserv.tldlistener.map", tldListenerMap);
        ServiceLocator defaultServices = this.webContainer.getServerContext().getDefaultServices();
        servletContext.setAttribute("org.glassfish.servlet.habitat", (Object)defaultServices);
        SunWebAppImpl bean = webModule.getIasWebAppConfigBean();
        Wrapper wrapper = (Wrapper)webModule.findChild("jsp");
        if (wrapper == null) {
            return;
        }
        if (webModule.getTldValidation()) {
            wrapper.addInitParameter("enableTldValidation", "true");
        }
        if (bean != null && bean.getJspConfig() != null) {
            WebProperty[] props = bean.getJspConfig().getWebProperty();
            for (int i = 0; i < props.length; ++i) {
                String pname = props[i].getAttributeValue("name");
                String pvalue = props[i].getAttributeValue("value");
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, JSP_CONFIG_PROPERTY, "[" + webModule.getID() + "] is [" + pname + "] = [" + pvalue + "]");
                }
                wrapper.addInitParameter(pname, pvalue);
            }
        }
        wrapper.addInitParameter("logVerbosityLevel", this.getJasperLogLevel());
        ResourceInjectorImpl resourceInjector = new ResourceInjectorImpl(webModule);
        servletContext.setAttribute("com.sun.appserv.jsp.resource.injector", (Object)resourceInjector);
        String sysClassPath = ASClassLoaderUtil.getModuleClassPath((ServiceLocator)defaultServices, (String)webModule.getID(), null);
        Boolean useMyFaces = (Boolean)servletContext.getAttribute("com.sun.faces.useMyFaces");
        if (useMyFaces != null && useMyFaces.booleanValue()) {
            sysClassPath = sysClassPath.replace("javax.faces.jar", "$disabled$.raj");
            sysClassPath = sysClassPath.replace("jsf-connector.jar", "$disabled$.raj");
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, SYS_CLASSPATH, webModule.getID() + " is " + sysClassPath);
        }
        if (sysClassPath.equals("")) {
            sysClassPath = System.getProperty("java.class.path");
        }
        sysClassPath = this.trimSysClassPath(sysClassPath);
        wrapper.addInitParameter("com.sun.appserv.jsp.classpath", sysClassPath);
        servletContext.setAttribute("org.glassfish.jsp.monitor.probeEmitter", (Object)new JspProbeEmitterImpl(webModule));
        InvocationManager invocationMgr = this.webContainer.getInvocationManager();
        WebComponentInvocation inv = new WebComponentInvocation(webModule);
        try {
            invocationMgr.preInvoke((ComponentInvocation)inv);
            JCDIService jcdiService = (JCDIService)defaultServices.getService(JCDIService.class, new Annotation[0]);
            if (jcdiService != null && jcdiService.isCurrentModuleJCDIEnabled()) {
                jcdiService.setELResolver(servletContext);
            }
        }
        catch (NamingException e) {
        }
        finally {
            invocationMgr.postInvoke((ComponentInvocation)inv);
        }
    }

    private void initIncludeJars() {
        if (this.includeInitialized) {
            return;
        }
        String includeJarsString = null;
        for (WebComponentDescriptor wcd : this.wbd.getWebComponentDescriptors()) {
            InitializationParameter initp;
            if (!"jsp".equals(wcd.getCanonicalName()) || (initp = wcd.getInitializationParameterByName("system-jar-includes")) == null) continue;
            includeJarsString = initp.getValue();
            break;
        }
        this.includeInitialized = true;
        if (includeJarsString == null) {
            this.includeJars = null;
            return;
        }
        this.includeJars = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(includeJarsString);
        while (tokenizer.hasMoreElements()) {
            this.includeJars.add(tokenizer.nextToken());
        }
    }

    private boolean included(String path) {
        for (String item : this.includeJars) {
            if (!path.contains(item)) continue;
            return true;
        }
        return false;
    }

    private String trimSysClassPath(String sysClassPath) {
        if (sysClassPath == null || sysClassPath.equals("")) {
            return "";
        }
        this.initIncludeJars();
        if (this.includeJars == null || this.includeJars.size() == 0) {
            return sysClassPath;
        }
        String sep = System.getProperty("path.separator");
        StringBuilder ret = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(sysClassPath, sep);
        String mySep = "";
        while (tokenizer.hasMoreElements()) {
            String path = tokenizer.nextToken();
            if (!this.included(path)) continue;
            ret.append(mySep);
            ret.append(path);
            mySep = sep;
        }
        return ret.toString();
    }

    private String getJasperLogLevel() {
        Level level = _logger.getLevel();
        if (level == null) {
            return "warning";
        }
        if (level.equals(Level.WARNING)) {
            return "warning";
        }
        if (level.equals(Level.FINE)) {
            return "information";
        }
        if (level.equals(Level.FINER) || level.equals(Level.FINEST)) {
            return "debug";
        }
        return "warning";
    }

    private void startCacheManager(WebModule webModule) {
        SunWebAppImpl bean = webModule.getIasWebAppConfigBean();
        if (bean != null) {
            CacheManager cm = null;
            try {
                cm = CacheModule.configureResponseCache(webModule, bean);
            }
            catch (Exception ee) {
                _logger.log(Level.WARNING, CACHE_MRG_EXCEPTION, ee);
            }
            if (cm != null) {
                try {
                    cm.start();
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, CACHE_MANAGER_STARTED);
                    }
                    ServletContext ctxt = webModule.getServletContext();
                    ctxt.setAttribute("com.sun.appserv.web.CacheManager", (Object)cm);
                }
                catch (LifecycleException ee) {
                    _logger.log(Level.WARNING, ee.getMessage(), ee.getCause());
                }
            }
        }
    }

    private void stopCacheManager(WebModule webModule) {
        ServletContext ctxt = webModule.getServletContext();
        CacheManager cm = (CacheManager)ctxt.getAttribute("com.sun.appserv.web.CacheManager");
        if (cm != null) {
            try {
                cm.stop();
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, CACHE_MANAGER_STOPPED);
                }
                ctxt.removeAttribute("com.sun.appserv.web.CacheManager");
            }
            catch (LifecycleException ee) {
                _logger.log(Level.WARNING, ee.getMessage(), ee.getCause());
            }
        }
    }

    private void configureDefaultServlet(WebModule webModule) {
        Wrapper wrapper = (Wrapper)webModule.findChild("default");
        if (wrapper == null) {
            return;
        }
        String servletClass = wrapper.getServletClassName();
        if (servletClass == null || !servletClass.equals(Globals.DEFAULT_SERVLET_CLASS_NAME)) {
            return;
        }
        String fileEncoding = webModule.getFileEncoding();
        if (fileEncoding != null) {
            wrapper.addInitParameter("fileEncoding", fileEncoding);
        }
    }
}

