/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.jsp;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.web.InitializationParameter;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.web.WebContainer;
import java.io.File;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.jasper.JspC;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.loader.util.ASClassLoaderUtil;
import org.glassfish.web.deployment.runtime.JspConfig;
import org.glassfish.web.deployment.runtime.SunWebAppImpl;
import org.glassfish.web.deployment.runtime.WebProperty;

public final class JSPCompiler {
    private static final Logger logger = WebContainer.logger;
    public static final String START_MESSAGE = "AS-WEB-GLUE-00281";
    public static final String FINISH_MESSAGE = "AS-WEB-GLUE-00282";
    public static final String CANNOT_DELETE_FILE = "AS-WEB-GLUE-00283";

    public static void compile(File inWebDir, File outWebDir, WebBundleDescriptor wbd, ServerContext serverContext) throws DeploymentException {
        String amb = null;
        JSPCompiler.compile(inWebDir, outWebDir, wbd, amb, serverContext);
    }

    public static void compile(File inWebDir, File outWebDir, WebBundleDescriptor wbd, List classpathList, ServerContext serverContext) throws DeploymentException {
        String classpath = null;
        if (classpathList != null) {
            classpath = JSPCompiler.getClasspath(classpathList);
        }
        JSPCompiler.compile(inWebDir, outWebDir, wbd, classpath, serverContext);
    }

    public static void compile(File inWebDir, File outWebDir, WebBundleDescriptor wbd, String classpath, ServerContext serverContext) throws DeploymentException {
        JspC jspc = new JspC();
        if (classpath != null && classpath.length() > 0) {
            jspc.setClassPath(classpath);
        }
        String appName = wbd.getApplication().getName();
        String sysClassPath = ASClassLoaderUtil.getModuleClassPath((ServiceLocator)serverContext.getDefaultServices(), (String)appName, null);
        jspc.setSystemClassPath(sysClassPath);
        JSPCompiler.verify(inWebDir, outWebDir);
        JSPCompiler.configureJspc(jspc, wbd);
        jspc.setOutputDir(outWebDir.getAbsolutePath());
        jspc.setUriroot(inWebDir.getAbsolutePath());
        jspc.setCompile(true);
        logger.log(Level.INFO, START_MESSAGE);
        try {
            jspc.execute();
        }
        catch (Exception je) {
            throw new DeploymentException("JSP Compilation Error: " + je, (Throwable)je);
        }
        finally {
            String[] files = outWebDir.list();
            if (!(files != null && files.length > 0 || outWebDir.delete())) {
                logger.log(Level.FINE, CANNOT_DELETE_FILE, outWebDir);
            }
            logger.log(Level.INFO, FINISH_MESSAGE);
        }
    }

    private static void verify(File inWebDir, File outWebDir) throws DeploymentException {
        if (!FileUtils.safeIsDirectory((File)inWebDir)) {
            throw new DeploymentException("inWebDir is not a directory: " + inWebDir);
        }
        if (!FileUtils.safeIsDirectory((File)outWebDir)) {
            if (!outWebDir.mkdirs()) {
                logger.log(Level.FINE, CANNOT_DELETE_FILE, outWebDir);
            }
            if (!FileUtils.safeIsDirectory((File)outWebDir)) {
                throw new DeploymentException("outWebDir is not a directory, and it can't be created: " + outWebDir);
            }
        }
    }

    private static String getClasspath(List paths) {
        if (paths == null) {
            return null;
        }
        String classpath = null;
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String path : paths) {
            if (first) {
                first = false;
            } else {
                sb.append(File.pathSeparatorChar);
            }
            sb.append(path);
        }
        if (sb.length() > 0) {
            classpath = sb.toString();
        }
        return classpath;
    }

    private static void configureJspc(JspC jspc, WebBundleDescriptor wbd) {
        JspConfig jspConfig;
        Set set;
        SunWebAppImpl sunWebApp = (SunWebAppImpl)wbd.getSunDescriptor();
        if (sunWebApp == null) {
            return;
        }
        if (sunWebApp.sizeWebProperty() > 0) {
            WebProperty[] props = sunWebApp.getWebProperty();
            for (int i = 0; i < props.length; ++i) {
                String pName = props[i].getAttributeValue("name");
                String pValue = props[i].getAttributeValue("value");
                if (pName == null || pValue == null) {
                    throw new IllegalArgumentException("Missing sun-web-app property name or value");
                }
                if (!"enableTldValidation".equals(pName)) continue;
                jspc.setIsValidationEnabled(Boolean.valueOf(pValue).booleanValue());
            }
        }
        if (!(set = wbd.getWebComponentDescriptors()).isEmpty()) {
            for (WebComponentDescriptor webComponentDesc : set) {
                if (!"jsp".equals(webComponentDesc.getCanonicalName())) continue;
                Enumeration en = webComponentDesc.getInitializationParameters();
                if (en == null) break;
                while (en.hasMoreElements()) {
                    InitializationParameter initP = (InitializationParameter)en.nextElement();
                    JSPCompiler.configureJspc(jspc, initP.getName(), initP.getValue());
                }
                break block1;
            }
        }
        if ((jspConfig = sunWebApp.getJspConfig()) == null) {
            return;
        }
        WebProperty[] props = jspConfig.getWebProperty();
        for (int i = 0; props != null && i < props.length; ++i) {
            JSPCompiler.configureJspc(jspc, props[i].getAttributeValue("name"), props[i].getAttributeValue("value"));
        }
    }

    private static void configureJspc(JspC jspc, String pName, String pValue) {
        if (pName == null || pValue == null) {
            throw new IllegalArgumentException("Null property name or value");
        }
        if ("xpoweredBy".equals(pName)) {
            jspc.setXpoweredBy(Boolean.valueOf(pValue).booleanValue());
        } else if ("classdebuginfo".equals(pName)) {
            jspc.setClassDebugInfo(Boolean.valueOf(pValue).booleanValue());
        } else if ("enablePooling".equals(pName)) {
            jspc.setPoolingEnabled(Boolean.valueOf(pValue).booleanValue());
        } else if ("ieClassId".equals(pName)) {
            jspc.setIeClassId(pValue);
        } else if ("trimSpaces".equals(pName)) {
            jspc.setTrimSpaces(Boolean.valueOf(pValue).booleanValue());
        } else if ("genStrAsCharArray".equals(pName)) {
            jspc.setGenStringAsCharArray(Boolean.valueOf(pValue).booleanValue());
        } else if ("errorOnUseBeanInvalidClassAttribute".equals(pName)) {
            jspc.setErrorOnUseBeanInvalidClassAttribute(Boolean.valueOf(pValue).booleanValue());
        } else if ("ignoreJspFragmentErrors".equals(pName)) {
            jspc.setIgnoreJspFragmentErrors(Boolean.valueOf(pValue).booleanValue());
        }
    }
}

