/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.web.cache;

import com.sun.appserv.web.cache.CacheHelper;
import com.sun.appserv.web.cache.CacheKeyGenerator;
import com.sun.appserv.web.cache.CacheManager;
import com.sun.appserv.web.cache.mapping.CacheMapping;
import com.sun.appserv.web.cache.mapping.ConstraintField;
import com.sun.appserv.web.cache.mapping.Field;
import com.sun.enterprise.web.WebContainer;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class DefaultCacheHelper
implements CacheHelper {
    private static final String[] KEY_PREFIXES = new String[]{"", "ca.", "rh.", "rp.", "rc.", "ra.", "sa.", "si."};
    public static final String ATTR_CACHING_FILTER_NAME = "com.sun.ias.web.cachingFilterName";
    public static final String PROP_KEY_GENERATOR_ATTR_NAME = "cacheKeyGeneratorAttrName";
    private static final Logger _logger = WebContainer.logger;
    private static final String CACHE_DEFAULT_HELP_ILLEGAL_KET_GENERATOR = "AS-WEB-GLUE-00003";
    private static final String REQUIRED_KEY_FIELDS_NOT_FOUND = "AS-WEB-GLUE-00004";
    ServletContext context;
    CacheManager manager;
    String attrKeyGenerator = null;
    boolean isKeyGeneratorChecked = false;
    CacheKeyGenerator keyGenerator;

    public void setCacheManager(CacheManager manager) {
        this.manager = manager;
    }

    @Override
    public void init(ServletContext context, Map<String, String> props) {
        this.context = context;
        this.attrKeyGenerator = props.get(PROP_KEY_GENERATOR_ATTR_NAME);
    }

    private CacheMapping lookupCacheMapping(HttpServletRequest request) {
        String name = (String)request.getAttribute(ATTR_CACHING_FILTER_NAME);
        if (this.manager != null) {
            return this.manager.getCacheMapping(name);
        }
        return null;
    }

    @Override
    public String getCacheKey(HttpServletRequest request) {
        String key;
        CacheMapping mapping = this.lookupCacheMapping(request);
        if (!this.isKeyGeneratorChecked && this.attrKeyGenerator != null) {
            try {
                this.keyGenerator = (CacheKeyGenerator)this.context.getAttribute(this.attrKeyGenerator);
            }
            catch (ClassCastException cce) {
                _logger.log(Level.WARNING, CACHE_DEFAULT_HELP_ILLEGAL_KET_GENERATOR, cce);
            }
            this.isKeyGeneratorChecked = true;
        }
        if (this.keyGenerator != null && (key = this.keyGenerator.getCacheKey(this.context, request)) != null) {
            return key;
        }
        StringBuilder sb = new StringBuilder(128);
        sb.append(request.getServletPath());
        Field[] keys = mapping.getKeyFields();
        for (int i = 0; i < keys.length; ++i) {
            Object value = keys[i].getValue(this.context, request);
            if (value == null) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, REQUIRED_KEY_FIELDS_NOT_FOUND, request.getServletPath());
                }
                return null;
            }
            sb.append(";");
            sb.append(KEY_PREFIXES[keys[i].getScope()]);
            sb.append(keys[i].getName());
            sb.append("=");
            sb.append(value);
        }
        return sb.toString();
    }

    @Override
    public boolean isCacheable(HttpServletRequest request) {
        boolean result = false;
        CacheMapping mapping = this.lookupCacheMapping(request);
        if (mapping.findMethod(request.getMethod())) {
            result = true;
            ConstraintField[] fields = mapping.getConstraintFields();
            for (int i = 0; i < fields.length; ++i) {
                if (fields[i].applyConstraints(this.context, request)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    @Override
    public boolean isRefreshNeeded(HttpServletRequest request) {
        Object value;
        boolean result = false;
        CacheMapping mapping = this.lookupCacheMapping(request);
        Field field = mapping.getRefreshField();
        if (field != null && (value = field.getValue(this.context, request)) != null && "true".equals(value.toString())) {
            result = true;
        }
        return result;
    }

    @Override
    public int getTimeout(HttpServletRequest request) {
        Object value;
        CacheMapping mapping = this.lookupCacheMapping(request);
        int result = mapping.getTimeout();
        Field field = mapping.getTimeoutField();
        if (field != null && (value = field.getValue(this.context, request)) != null) {
            try {
                Integer timeoutAttr = Integer.valueOf(value.toString());
                result = timeoutAttr;
            }
            catch (NumberFormatException cce) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public void destroy() throws Exception {
    }
}

