/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.util;

import com.sun.enterprise.tools.verifier.Result;
import java.io.File;
import java.io.FileInputStream;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class BundledOptPkgHasDependencies {
    public static void test(String explodedJarPath, Result result) {
        try (FileInputStream fis = new FileInputStream(new File(explodedJarPath + File.separator + "META-INF/MANIFEST.MF"));){
            boolean failed = false;
            Manifest manifest = new Manifest(fis);
            String depClassPath = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
            if (depClassPath != null) {
                StringTokenizer st = new StringTokenizer(depClassPath);
                while (st.hasMoreTokens()) {
                    String entry = st.nextToken();
                    String entryPath = new File(explodedJarPath).getParent() + File.separator + entry;
                    File bundledOptPkg = new File(entryPath);
                    if (bundledOptPkg.isDirectory()) continue;
                    JarFile jf = new JarFile(bundledOptPkg);
                    Throwable throwable = null;
                    try {
                        Manifest bundledManifest = jf.getManifest();
                        String bundledCP = bundledManifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
                        if (bundledCP == null || bundledCP.length() == 0) continue;
                        failed = true;
                        result.failed(entry + " contains Class-Path in it's manifest.");
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (jf == null) continue;
                        if (throwable != null) {
                            try {
                                jf.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        jf.close();
                    }
                }
            }
            if (!failed) {
                result.setStatus(0);
            }
        }
        catch (Exception e) {
            result.failed(e.toString());
        }
    }
}

