/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.session.createmethod;

import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.VerifierTestContext;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbUtils;
import java.lang.reflect.Method;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbSessionDescriptor;

public class HomeInterfaceCreateMethodExceptionRemote
extends EjbTest
implements EjbCheck {
    @Override
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        if (descriptor instanceof EjbSessionDescriptor) {
            boolean oneFailed = false;
            boolean foundAtLeastOneRemote = false;
            if (descriptor.getHomeClassName() == null || "".equals(descriptor.getHomeClassName())) {
                result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.addNaDetails(smh.getLocalString(this.getClass().getName() + ".notApplicable1", "No Remote Home Interface for this ejb", new Object[0]));
                return result;
            }
            try {
                VerifierTestContext context = this.getVerifierContext();
                ClassLoader jcl = context.getClassLoader();
                Class<?> c = Class.forName(descriptor.getHomeClassName(), false, this.getVerifierContext().getClassLoader());
                Method[] methods = c.getDeclaredMethods();
                boolean throwsRemoteException = false;
                for (int i = 0; i < methods.length; ++i) {
                    Class[] methodExceptionTypes;
                    throwsRemoteException = false;
                    if (!methods[i].getName().startsWith("create")) continue;
                    if (!foundAtLeastOneRemote) {
                        foundAtLeastOneRemote = true;
                    }
                    if (EjbUtils.isValidRemoteException(methodExceptionTypes = methods[i].getExceptionTypes())) {
                        throwsRemoteException = true;
                    }
                    if (throwsRemoteException) {
                        result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                        result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For Home Interface [ {0} ] Method [ {1} ]", new Object[]{c.getName(), methods[i].getName()}));
                        result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "The create method which must throw java.rmi.RemoteException was found."));
                        continue;
                    }
                    if (throwsRemoteException) continue;
                    oneFailed = true;
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For Home Interface [ {0} ] Method [ {1} ]", new Object[]{c.getName(), methods[i].getName()}));
                    result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: A create method was found, but did not throw java.rmi.RemoteException."));
                }
            }
            catch (ClassNotFoundException e) {
                Verifier.debug(e);
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Home interface [ {0} ] does not exist or is not loadable within bean [ {1} ]", new Object[]{descriptor.getHomeClassName(), descriptor.getName()}));
            }
            if (!foundAtLeastOneRemote) {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".debug3", "For Home Interface [ {0} ]", new Object[]{descriptor.getHomeClassName()}));
                result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed1", "No create method was found in [ {0} ]", new Object[]{descriptor.getHomeClassName()}));
                result.setStatus(1);
            } else if (oneFailed) {
                result.setStatus(1);
            } else {
                result.setStatus(0);
            }
            return result;
        }
        result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
        result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Session", "Entity"}));
        return result;
    }
}

