/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.ejbcreatemethod;

import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.VerifierTestContext;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbEntityDescriptor;

public class EjbCreateMethodFinal
extends EjbTest
implements EjbCheck {
    @Override
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        if (descriptor instanceof EjbEntityDescriptor) {
            boolean oneFailed = false;
            int foundAtLeastOne = 0;
            try {
                VerifierTestContext context = this.getVerifierContext();
                ClassLoader jcl = context.getClassLoader();
                Class<?> c = Class.forName(descriptor.getEjbClassName(), false, this.getVerifierContext().getClassLoader());
                boolean ejbCreateFound = false;
                boolean isFinal = false;
                block2: do {
                    Method[] methods = c.getDeclaredMethods();
                    for (int i = 0; i < methods.length; ++i) {
                        ejbCreateFound = false;
                        isFinal = false;
                        if (!methods[i].getName().startsWith("ejbCreate")) continue;
                        ++foundAtLeastOne;
                        ejbCreateFound = true;
                        int modifiers = methods[i].getModifiers();
                        if (Modifier.isFinal(modifiers)) {
                            isFinal = true;
                        }
                        if (!ejbCreateFound || !isFinal) continue;
                        oneFailed = true;
                        result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                        result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For EJB Class [ {0} ] method [ {1} ]", new Object[]{descriptor.getEjbClassName(), methods[i].getName()}));
                        result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: A final [ {0} ] method was found, but [ {1} ] cannot be declared as final.", new Object[]{methods[i].getName(), methods[i].getName()}));
                        continue block2;
                    }
                } while (!oneFailed && (c = c.getSuperclass()) != null && foundAtLeastOne == 0);
                if (foundAtLeastOne == 0) {
                    result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable1", "[ {0} ] does not declare any ejbCreate(...) methods.", new Object[]{descriptor.getEjbClassName()}));
                }
                if (!oneFailed && foundAtLeastOne > 0) {
                    result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For EJB Class [ {0} ] ", new Object[]{descriptor.getEjbClassName()}));
                    result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "[ {0} ] properly declares non-final ejbCreate<method> method.", new Object[]{descriptor.getEjbClassName()}));
                }
            }
            catch (ClassNotFoundException e) {
                Verifier.debug(e);
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: [ {0} ] class not found.", new Object[]{descriptor.getEjbClassName()}));
                oneFailed = true;
            }
            if (oneFailed) {
                result.setStatus(1);
            } else if (foundAtLeastOne == 0) {
                result.setStatus(3);
            } else {
                result.setStatus(0);
            }
            return result;
        }
        result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
        result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Entity", "Session"}));
        return result;
    }
}

