/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity;

import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbEntityDescriptor;

public class EjbNameIsValidJavaIdentifier
extends EjbTest
implements EjbCheck {
    @Override
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        String ejbName = descriptor.getName();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        if (descriptor instanceof EjbEntityDescriptor && ((EjbEntityDescriptor)descriptor).getPersistenceType().equals("Container")) {
            boolean isJavaIdentifier = true;
            boolean startChar = Character.isJavaIdentifierStart(ejbName.charAt(0));
            if (startChar) {
                for (int i = 1; i < ejbName.length(); ++i) {
                    if (Character.isJavaIdentifierPart(ejbName.charAt(i))) continue;
                    isJavaIdentifier = false;
                    break;
                }
            } else {
                isJavaIdentifier = false;
            }
            if (isJavaIdentifier) {
                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "ejb-name [ {0} ] within bean [ {1} ] is a valid java identifier", new Object[]{ejbName, descriptor.getName()}));
                return result;
            }
            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "ejb-name [ {0} ] within bean [ {1} ] is not a valid java identifier", new Object[]{ejbName, descriptor.getName()}));
            return result;
        }
        result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
        result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, with Container Managed Persistence.", new Object[]{this.getClass(), "Entity"}));
        return result;
    }
}

