/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb;

import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbUtils;
import java.lang.reflect.Method;
import java.util.Set;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbEntityDescriptor;

public class ApplicationExceptionComponentInterfaceMethods
extends EjbTest
implements EjbCheck {
    Result result = null;
    ComponentNameConstructor compName = null;

    @Override
    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        this.compName = this.getVerifierContext().getComponentNameConstructor();
        if (descriptor instanceof EjbSessionDescriptor || descriptor instanceof EjbEntityDescriptor) {
            if (descriptor.getRemoteClassName() != null) {
                this.commonToBothInterfaces(descriptor.getRemoteClassName(), descriptor);
            }
            if (descriptor.getLocalClassName() != null) {
                this.commonToBothInterfaces(descriptor.getLocalClassName(), descriptor);
            }
            Set localAndRemoteInterfaces = descriptor.getLocalBusinessClassNames();
            localAndRemoteInterfaces.addAll(descriptor.getRemoteBusinessClassNames());
            for (String localOrRemoteIntf : localAndRemoteInterfaces) {
                this.commonToBothInterfaces(localOrRemoteIntf, descriptor);
            }
        }
        if (this.result.getStatus() != 1) {
            this.addGoodDetails(this.result, this.compName);
            this.result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "All the business methods are defined properly"));
        }
        return this.result;
    }

    private void commonToBothInterfaces(String remote, EjbDescriptor descriptor) {
        try {
            Class<?> c = Class.forName(remote, false, this.getVerifierContext().getClassLoader());
            for (Method methods : c.getDeclaredMethods()) {
                Class[] methodExceptionTypes = methods.getExceptionTypes();
                if (EjbUtils.isValidApplicationException(methodExceptionTypes)) continue;
                this.addErrorDetails(this.result, this.compName);
                this.result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "For the Interface [ {0} ] Method [ {1} ] does not throw valid application exceptions", new Object[]{remote, methods.getName()}));
            }
        }
        catch (Exception e) {
            Verifier.debug(e);
            this.addErrorDetails(this.result, this.compName);
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Remote interface [ {0} ] does not exist or is not loadable within bean [ {1} ]", new Object[]{remote, descriptor.getName()}));
        }
    }
}

