/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.connector.managed;

import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.OutboundResourceAdapter;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorCheck;
import com.sun.enterprise.tools.verifier.tests.connector.managed.ManagedConnectionFactoryTest;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Set;

public class ManagedConnectionFactoryProperties
extends ManagedConnectionFactoryTest
implements ConnectorCheck {
    @Override
    public Result check(ConnectorDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        if (!descriptor.getOutBoundDefined()) {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.managed.notApplicableForInboundRA", "Resource Adapter does not provide outbound communication"));
            return result;
        }
        boolean oneFailed = false;
        OutboundResourceAdapter outboundRA = descriptor.getOutboundResourceAdapter();
        Set connDefs = outboundRA.getConnectionDefs();
        for (ConnectionDefDescriptor connDefDesc : connDefs) {
            Set configProperties = connDefDesc.getConfigProperties();
            if (configProperties.isEmpty()) continue;
            Iterator propIterator = configProperties.iterator();
            Class mcf = this.testManagedConnectionFactoryImpl(descriptor, result);
            if (mcf == null) {
                return result;
            }
            while (propIterator.hasNext()) {
                EnvironmentProperty ep = (EnvironmentProperty)propIterator.next();
                String propertyName = Character.toUpperCase(ep.getName().charAt(0)) + ep.getName().substring(1);
                String setMethodName = "set" + propertyName;
                Class[] parmTypes = new Class[]{ep.getValueType()};
                Method m = ManagedConnectionFactoryProperties.getMethod(mcf, setMethodName, parmTypes);
                if (m != null) {
                    result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "Found a JavaBeans compliant accessor method [ {0} ] for the config-property [ {1} ]", new Object[]{m, ep.getName()}));
                } else {
                    oneFailed = true;
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: There is no JavaBeans compliant accessor method [ {0} ] implemented in [ {1} ] for the config-property [ {2} ]", new Object[]{"public void " + setMethodName + "(" + ep.getValueType().getName() + ")", mcf.getName(), ep.getName()}));
                }
                String getMethodName = "get" + propertyName;
                m = ManagedConnectionFactoryProperties.getMethod(mcf, getMethodName, null);
                if (m != null) {
                    result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "Found a JavaBeans compliant accessor method [ {0} ] for the config-property [ {1} ]", new Object[]{m, ep.getName()}));
                    continue;
                }
                oneFailed = true;
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: There is no JavaBeans compliant accessor method [ {0} ] implemented in [ {1} ] for the config-property [ {2} ]", new Object[]{"public " + ep.getValueType().getName() + " " + getMethodName, mcf.getName(), ep.getName()}));
            }
        }
        if (oneFailed) {
            result.setStatus(1);
        } else {
            result.setStatus(0);
        }
        return result;
    }
}

