/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.appclient.elements;

import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.appclient.AppClientCheck;
import com.sun.enterprise.tools.verifier.tests.appclient.AppClientTest;

public class AppClientEjbRefTypeElement
extends AppClientTest
implements AppClientCheck {
    @Override
    public Result check(ApplicationClientDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        boolean failed = false;
        if (!descriptor.getEjbReferenceDescriptors().isEmpty()) {
            for (EjbReferenceDescriptor nextEjbReference : descriptor.getEjbReferenceDescriptors()) {
                String ejbRefTypeStr = nextEjbReference.getType();
                if (ejbRefTypeStr.equals("Session") || ejbRefTypeStr.equals("Entity")) continue;
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: ejb-ref-type [ {0} ] within \n application client [ {1} ] is not valid.  \n Must be [ {2} ] or [ {3} ]", new Object[]{ejbRefTypeStr, descriptor.getName(), "Entity", "Session"}));
                failed = true;
            }
        } else {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no ejb references to other beans within this application client [ {0} ]", new Object[]{descriptor.getName()}));
            return result;
        }
        if (failed) {
            result.setStatus(1);
        } else {
            result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "All ejb-ref-type elements are valid.  They are all [ {0} ] or [ {1} ] within this application client [ {2} ]", new Object[]{"Entity", "Session", descriptor.getName()}));
        }
        return result;
    }
}

