/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.apiscan.stdapis;

import com.sun.enterprise.tools.verifier.apiscan.classfile.ClassFileLoader;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClassFileLoaderFactory;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClosureCompilerImpl;
import com.sun.enterprise.tools.verifier.apiscan.packaging.ClassPathBuilder;
import com.sun.enterprise.tools.verifier.apiscan.stdapis.APIRepository;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.jar.JarFile;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EjbClosureCompiler
extends ClosureCompilerImpl {
    private static Logger logger = Logger.getLogger("apiscan.stdapis");
    private static final String myClassName = "EjbClosureCompiler";
    private String specVersion;

    public EjbClosureCompiler(String specVersion, ClassFileLoader cfl) {
        super(cfl);
        logger.entering(myClassName, "init<>", specVersion);
        this.specVersion = specVersion;
        this.addStandardAPIs();
    }

    protected void addStandardAPIs() {
        String apiName = "ejb_jar_" + this.specVersion;
        Collection<String> classes = APIRepository.Instance().getClassesFor(apiName);
        Iterator<String> i = classes.iterator();
        while (i.hasNext()) {
            this.addExcludedClass(i.next());
        }
        Collection<String> pkgs = APIRepository.Instance().getPackagesFor(apiName);
        Iterator<String> i2 = pkgs.iterator();
        while (i2.hasNext()) {
            this.addExcludedPackage(i2.next());
        }
        Collection<String> patterns = APIRepository.Instance().getPatternsFor(apiName);
        Iterator<String> i3 = patterns.iterator();
        while (i3.hasNext()) {
            this.addExcludedPattern(i3.next());
        }
    }

    public static void main(String[] args) {
        ConsoleHandler h = new ConsoleHandler();
        h.setLevel(Level.ALL);
        Logger.getLogger("apiscan").addHandler(h);
        Logger.getLogger("apiscan").setLevel(Level.ALL);
        int j = 0;
        String pcp = "";
        String specVer = "";
        for (j = 0; j < args.length; ++j) {
            if (args[j].equals("-prefixClassPath")) {
                pcp = args[++j];
                continue;
            }
            if (!args[j].equals("-specVer")) continue;
            specVer = args[++j];
        }
        if (args.length < 5) {
            System.out.println("Usage: " + EjbClosureCompiler.class.getName() + " <-prefixClassPath> <prefix classpath> <-specVer> <something like ejb_2.1> <jar file name(s)>");
            return;
        }
        for (int i = 4; i < args.length; ++i) {
            try (JarFile jar = new JarFile(args[i]);){
                String cp = pcp + File.pathSeparator + ClassPathBuilder.buildClassPathForJar(jar);
                System.out.println("Using CLASSPATH " + cp);
                ClassFileLoader cfl = ClassFileLoaderFactory.newInstance(new Object[]{cp});
                EjbClosureCompiler ejbClosureCompiler = new EjbClosureCompiler(specVer, cfl);
                boolean result = ejbClosureCompiler.buildClosure(jar);
                jar.close();
                System.out.println("The closure is [\n");
                System.out.println(ejbClosureCompiler);
                if (result) {
                    System.out.println("Did not find any non-standard APIs ");
                } else {
                    System.out.println("Found non-standard APIs for " + args[i]);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            System.out.println("\n]");
        }
    }
}

