/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.apiscan.classfile;

import com.sun.enterprise.tools.verifier.apiscan.classfile.BCELClassFile;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClassFile;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClassFileLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

class BCELClassFileLoader
implements ClassFileLoader {
    private ClassLoader cl;
    private static String resourceBundleName = "com.sun.enterprise.tools.verifier.apiscan.LocalStrings";
    private static Logger logger = Logger.getLogger("apiscan.classfile", resourceBundleName);
    private static final String myClassName = "BCELClassFileLoader";

    public BCELClassFileLoader(String cp) {
        ArrayList<URL> urls = new ArrayList<URL>();
        StringTokenizer st = new StringTokenizer(cp, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String entry = st.nextToken();
            try {
                urls.add(new File(entry).toURI().toURL());
            }
            catch (MalformedURLException e) {
                logger.logp(Level.WARNING, myClassName, "init<>", this.getClass().getName() + ".exception1", new Object[]{entry});
                logger.log(Level.WARNING, "", e);
            }
        }
        this.cl = new URLClassLoader(urls.toArray(new URL[0]), null);
    }

    public BCELClassFileLoader(ClassLoader cl) {
        this.cl = cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassFile load(String externalClassName) throws IOException {
        logger.entering(myClassName, "load", externalClassName);
        String internalClassName = externalClassName.replace('.', '/');
        URL resource = this.cl.getResource(internalClassName + ".class");
        if (resource == null) {
            throw new IOException("Not able to load " + internalClassName + ".class");
        }
        URLConnection urlcon = resource.openConnection();
        urlcon.setUseCaches(false);
        try (InputStream is = urlcon.getInputStream();){
            BCELClassFile cf = new BCELClassFile(is, internalClassName + ".class");
            this.matchClassSignature(cf, externalClassName);
            BCELClassFile bCELClassFile = cf;
            return bCELClassFile;
        }
    }

    private void matchClassSignature(ClassFile cf, String externalClassName) throws IOException {
        String nameOfLoadedClass = cf.getName();
        if (!nameOfLoadedClass.equals(externalClassName)) {
            throw new IOException(externalClassName + ".class represents " + cf.getName() + ". Perhaps your package name is incorrect or you passed the name using internal form instead of using external form.");
        }
    }
}

