/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.wsclients;

import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.wsclients.WSClientCheck;
import com.sun.enterprise.tools.verifier.tests.wsclients.WSClientTest;
import java.util.Set;

public class PortCompRefSEIClassCheck
extends WSClientTest
implements WSClientCheck {
    ComponentNameConstructor compName;

    @Override
    public Result check(ServiceReferenceDescriptor descriptor) {
        Result result = this.getInitializedResult();
        this.compName = this.getVerifierContext().getComponentNameConstructor();
        boolean pass = true;
        Set ports = descriptor.getPortsInfo();
        for (ServiceRefPortInfo ref : ports) {
            if (!this.loadSEIClass(ref, result)) {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: Service Endpoint Interface class [ {0} ]  not found.", new Object[]{ref.getServiceEndpointInterface()}));
                pass = false;
                continue;
            }
            result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Service Endpoint Interface class [ {0} ]  found.", new Object[]{ref.getServiceEndpointInterface()}));
        }
        return result;
    }

    private boolean loadSEIClass(ServiceRefPortInfo ref, Result result) {
        boolean pass = true;
        if (ref.hasServiceEndpointInterface()) {
            try {
                Class.forName(ref.getServiceEndpointInterface(), false, this.getVerifierContext().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                Verifier.debug(e);
                pass = false;
            }
        } else {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notapp", "Not applicable since Service reference does not specify an SEI."));
        }
        return pass;
    }
}

