/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.webservices;

import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.webservices.WSCheck;
import com.sun.enterprise.tools.verifier.tests.webservices.WSTest;
import java.io.IOException;
import java.io.InputStream;

public class WSXMLLocCheck
extends WSTest
implements WSCheck {
    private String ejbWSXmlLoc = "META-INF/webservices.xml";
    private String jaxrpcWSXmlLoc = "WEB-INF/webservices.xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result check(WebServiceEndpoint descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        InputStream deploymentEntry = null;
        try {
            String uri = this.getAbstractArchiveUri(descriptor);
            FileArchive arch = new FileArchive();
            arch.open(uri);
            if (descriptor.implementedByEjbComponent()) {
                deploymentEntry = arch.getEntry(this.ejbWSXmlLoc);
            } else if (descriptor.implementedByWebComponent()) {
                deploymentEntry = arch.getEntry(this.jaxrpcWSXmlLoc);
            } else {
                throw new Exception("Niether implemented by EJB nor by WEB Component");
            }
            if (deploymentEntry != null) {
                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "The webservices.xml file for [{0}] is located at the correct place.", new Object[]{compName.toString()}));
            } else {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "The webservices.xml file for [{0}] is not located in WEB-INF/META-INF directory as applicable.", new Object[]{compName.toString()}));
            }
        }
        catch (Exception e) {
            result.addErrorDetails(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.Error", "Error: Unexpected error occurred [ {0} ]", new Object[]{e.getMessage()}));
        }
        finally {
            try {
                if (deploymentEntry != null) {
                    deploymentEntry.close();
                }
            }
            catch (IOException iOException) {}
        }
        return result;
    }
}

