/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.webservices;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.webservices.EndPointImplBeanClassChecker;
import com.sun.enterprise.tools.verifier.tests.webservices.WSCheck;
import com.sun.enterprise.tools.verifier.tests.webservices.WSTest;
import java.util.Vector;
import javax.ejb.SessionBean;

public class EJBServiceImplBeanChk
extends WSTest
implements WSCheck {
    @Override
    public Result check(WebServiceEndpoint wsdescriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        EjbDescriptor descriptor = wsdescriptor.getEjbComponentImpl();
        if (descriptor != null) {
            String beanClass = descriptor.getEjbClassName();
            if (beanClass == null || beanClass != null && beanClass.length() == 0) {
                result.addErrorDetails(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.Error", "Error: Unexpected error occurred [ {0} ]", new Object[]{"Service Implementation Bean Class Name Null"}));
            }
            Class<?> bean = null;
            try {
                bean = Class.forName(beanClass, false, this.getVerifierContext().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "The [{0}] Class [{1}] could not be Loaded", new Object[]{"Service Impl Bean", beanClass}));
            }
            String s = descriptor.getWebServiceEndpointInterfaceName();
            if (s == null || s.length() == 0) {
                result.addErrorDetails(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.Error", "Error: Unexpected error occurred [ {0} ]", new Object[]{"Service Endpoint Interface Class Name Null"}));
            }
            Class<?> sei = null;
            try {
                sei = Class.forName(s, false, this.getVerifierContext().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "The [{0}] Class [{1}] could not be Loaded", new Object[]{"SEI", s}));
            }
            boolean isSLSB = SessionBean.class.isAssignableFrom(bean);
            boolean implementsSEI = sei.isAssignableFrom(bean);
            if (!isSLSB) {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.failed", "[{0}]", new Object[]{"The Service Implementation Bean Does not Implement SessionBean Interface"}));
            } else {
                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.passed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.passed", "[{0}]", new Object[]{"The Service Impl Bean implements SessionBean Interface"}));
            }
            EndPointImplBeanClassChecker checker = new EndPointImplBeanClassChecker(sei, bean, result, this.getVerifierContext().getSchemaVersion());
            if (implementsSEI) {
                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.passed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.passed", "[{0}]", new Object[]{"The Service Impl Bean implements SEI"}));
            } else {
                Vector notImpl = checker.getSEIMethodsNotImplemented();
                if (notImpl.size() > 0) {
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.failed", "[{0}]", new Object[]{"The Service Implementation Bean Does not Implement ALL SEI Methods"}));
                } else {
                    result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.passed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.passed", "[{0}]", new Object[]{"The Service Impl Bean implements  all Methods of the SEI"}));
                }
            }
            if (checker.check(compName)) {
                result.setStatus(0);
            } else {
                result.setStatus(1);
            }
        } else {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.notapp", "[{0}]", new Object[]{"Not Applicable since this is a JAX-RPC Service Endpoint"}));
        }
        return result;
    }
}

