/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.tools.verifier.VerifierEventsListener;
import com.sun.enterprise.tools.verifier.web.WebCheckMgrImpl;
import java.io.File;
import java.util.EventObject;

public class WebTestsUtil
implements VerifierEventsListener {
    protected final String listenerClassPath = "WEB-INF/classes";
    protected final String libraryClassPath = "WEB-INF/lib";
    private final String separator = System.getProperty("file.separator");
    private static File warFile = new File(System.getProperty("java.io.tmpdir"), "listenertmp");
    private static WebTestsUtil util = null;
    private static ClassLoader cl = null;

    public static WebTestsUtil getUtil(ClassLoader cLoader) {
        if (util == null) {
            util = new WebTestsUtil();
            WebCheckMgrImpl.addVerifierEventsListener(util);
            cl = cLoader;
        }
        return util;
    }

    private void deleteDirectory(String oneDir) {
        File cleanDir = new File(oneDir);
        if (!cleanDir.exists()) {
            return;
        }
        File[] listOfFiles = cleanDir.listFiles();
        if (listOfFiles != null) {
            for (int countFiles = 0; countFiles < listOfFiles.length; ++countFiles) {
                if (listOfFiles[countFiles].isFile()) {
                    listOfFiles[countFiles].delete();
                    continue;
                }
                String nextCleanDir = cleanDir + this.separator + listOfFiles[countFiles].getName();
                File newCleanDir = new File(nextCleanDir);
                this.deleteDirectory(newCleanDir.getAbsolutePath());
            }
        }
        cleanDir.delete();
    }

    @Override
    public void testFinished(EventObject e) {
    }

    @Override
    public void allTestsFinished(EventObject e) {
        if (warFile != null && warFile.exists()) {
            this.deleteDirectory(warFile.getAbsolutePath());
        }
        warFile = null;
        util = null;
        cl = null;
        WebCheckMgrImpl.removeVerifierEventsListener(this);
    }

    private ClassLoader getClassLoader() {
        return cl;
    }

    public Class loadClass(String className) throws Throwable {
        if (!(warFile != null && warFile.exists() || this.getClassLoader() != null)) {
            throw new ClassNotFoundException();
        }
        Class<?> c = this.getClassLoader().loadClass(className);
        return c;
    }
}

