/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.TagLibDescriptor;
import com.sun.enterprise.tools.verifier.VerifierTestContext;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;

public class TaglibListenerClassExists
extends WebTest
implements WebCheck {
    @Override
    public Result check(WebBundleDescriptor descriptor) {
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        VerifierTestContext context = this.getVerifierContext();
        Result result = this.getInitializedResult();
        TagLibDescriptor[] tlds = context.getTagLibDescriptors();
        ClassLoader cl = context.getClassLoader();
        if (tlds == null) {
            this.addGoodDetails(result, compName);
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "No tag lib files are specified"));
            return result;
        }
        for (TagLibDescriptor tld : tlds) {
            String[] classes = tld.getListenerClasses();
            if (classes == null) continue;
            for (String s : classes) {
                Class<?> c = null;
                try {
                    c = Class.forName(s, false, cl);
                }
                catch (ClassNotFoundException e) {
                    this.addErrorDetails(result, compName);
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Taglib listener class [ {0} ] found in [ {1} ] is not loadable ", new Object[]{s, tld.getUri()}));
                }
            }
        }
        if (result.getStatus() != 1) {
            this.addGoodDetails(result, compName);
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed1", "taglib listener classes, if any, specified in tlds are loadable"));
        }
        return result;
    }
}

