/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;

public class ServletLoadOnStartup
extends WebTest
implements WebCheck {
    @Override
    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        boolean oneFailed = false;
        if (!descriptor.getServletDescriptors().isEmpty()) {
            for (WebComponentDescriptor nextServletDescriptor : descriptor.getServletDescriptors()) {
                Integer loadOnStartUp = new Integer(nextServletDescriptor.getLoadOnStartUp());
                if (loadOnStartUp >= 0) {
                    result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "load-on-startup [ {0} ] value found in [ {1} ]", new Object[]{loadOnStartUp, nextServletDescriptor.getName()}));
                    continue;
                }
                if (!oneFailed) {
                    oneFailed = true;
                }
                result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: load-on-startup [ {0} ] invalid value found in [ {1} ]", new Object[]{loadOnStartUp, nextServletDescriptor.getName()}));
            }
            if (oneFailed) {
                result.setStatus(1);
            } else {
                result.setStatus(0);
            }
        } else {
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no servlets within this web archive [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

