/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.session;

import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Method;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbSessionDescriptor;

public class HomeInterfaceNoFinderMethodNames
extends EjbTest
implements EjbCheck {
    Result result = null;
    ComponentNameConstructor compName = null;

    @Override
    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        this.compName = this.getVerifierContext().getComponentNameConstructor();
        if (descriptor instanceof EjbSessionDescriptor) {
            if (descriptor.getHomeClassName() != null && !"".equals(descriptor.getHomeClassName())) {
                this.commonToBothInterfaces(descriptor.getHomeClassName(), (EjbSessionDescriptor)descriptor);
            }
            if (descriptor.getLocalHomeClassName() != null && !"".equals(descriptor.getLocalHomeClassName())) {
                this.commonToBothInterfaces(descriptor.getLocalHomeClassName(), (EjbSessionDescriptor)descriptor);
            }
        }
        if (this.result.getStatus() != 1) {
            this.addGoodDetails(this.result, this.compName);
            this.result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Valid: no finder methods were found.  Session bean's home interface is not allowed to have any finder methods."));
        }
        return this.result;
    }

    private void commonToBothInterfaces(String home, EjbSessionDescriptor descriptor) {
        try {
            Class<?> c = Class.forName(home, false, this.getVerifierContext().getClassLoader());
            for (Method methods : c.getDeclaredMethods()) {
                if (!methods.getName().startsWith("find")) continue;
                this.addErrorDetails(this.result, this.compName);
                this.result.failed(smh.getLocalString(this.getClass().getName() + ".debug1", "For Home Interface [ {0} ] Method [ {1} ]", new Object[]{c.getName(), methods.getName()}));
                this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Improperly named method [ {0} ] was found. Session bean's home interface is not allowed to have any finder methods.", new Object[]{methods.getName()}));
            }
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            this.addErrorDetails(this.result, this.compName);
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Home interface [ {0} ] does not exist or is not loadable within bean [ {1} ]", new Object[]{home, descriptor.getName()}));
        }
    }
}

