/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.session;

import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbSessionDescriptor;

public class BeanFieldsTransient
extends EjbTest
implements EjbCheck {
    @Override
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        if (descriptor instanceof EjbSessionDescriptor) {
            try {
                Class<?> c = Class.forName(((EjbSessionDescriptor)descriptor).getEjbClassName(), false, this.getVerifierContext().getClassLoader());
                Field[] fields = c.getDeclaredFields();
                for (int i = 0; i < fields.length; ++i) {
                    int modifiers = fields[i].getModifiers();
                    if (!Modifier.isTransient(modifiers)) continue;
                    this.addWarningDetails(result, compName);
                    result.warning(smh.getLocalString(this.getClass().getName() + ".warning", "Warning: Field [ {0} ] defined within session bean class [ {1} ] is defined as transient.  Session bean fields should not be defined in the session bean class as transient.", new Object[]{fields[i].getName(), ((EjbSessionDescriptor)descriptor).getEjbClassName()}));
                }
            }
            catch (ClassNotFoundException e) {
                Verifier.debug(e);
                this.addErrorDetails(result, compName);
                result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: [ {0} ] class not found.", new Object[]{((EjbSessionDescriptor)descriptor).getEjbClassName()}));
            }
            catch (Throwable t) {
                this.addWarningDetails(result, compName);
                result.warning(smh.getLocalString(this.getClass().getName() + ".warningException", "Warning: [ {0} ] class encountered [ {1} ]. Cannot access fields of class [ {2} ] which is external to [ {3} ].", new Object[]{descriptor.getEjbClassName(), t.toString(), t.getMessage(), descriptor.getEjbBundleDescriptor().getModuleDescriptor().getArchiveUri()}));
            }
            return result;
        }
        if (result.getStatus() != 2) {
            this.addGoodDetails(result, compName);
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "The session bean class has defined all fields as non-transient fields."));
        }
        return result;
    }
}

