/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.runtime;

import com.sun.enterprise.deployment.ResourcePrincipal;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import org.glassfish.ejb.deployment.descriptor.EjbBundleDescriptorImpl;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;

public class ASEntBeanCmpResource
extends EjbTest
implements EjbCheck {
    boolean oneFailed = false;
    boolean oneWarning = false;

    @Override
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        try {
            EjbBundleDescriptorImpl ejbBundleDesc = descriptor.getEjbBundleDescriptor();
            ResourceReferenceDescriptor cmpResource = ejbBundleDesc.getCMPResourceReference();
            if (cmpResource != null) {
                String jndiName = this.getXPathValue("sun-ejb-jar/enterprise-beans/cmp-resource/jndi-name");
                if (jndiName == null || jndiName.length() == 0) {
                    this.oneFailed = true;
                    this.addErrorDetails(result, compName);
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "FAILED [AS-EJB cmp-resource] : jndi-name cannot be an empty string"));
                } else if (jndiName.startsWith("jdbc/") || jndiName.startsWith("jdo/")) {
                    this.addGoodDetails(result, compName);
                    result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "PASSED [AS-EJB cmp-resource] : jndi-name is {0}", new Object[]{jndiName}));
                } else {
                    this.oneWarning = true;
                    this.addWarningDetails(result, compName);
                    result.warning(smh.getLocalString(this.getClass().getName() + ".warning", "WARNING [AS-EJB cmp-resource] : The jndi-name  is {0}, the preferred jndi-name should start with  jdbc/ or jdo/", new Object[]{jndiName}));
                }
                ResourcePrincipal defPrincipal = cmpResource.getResourcePrincipal();
                if (defPrincipal != null) {
                    String name = this.getXPathValue("sun-ejb-jar/enterprise-beans/cmp-resource/default-resource-principal/name");
                    if (name == null || name.length() == 0) {
                        this.oneFailed = true;
                        this.addErrorDetails(result, compName);
                        result.failed(smh.getLocalString(this.getClass().getName() + ".failed2", "FAILED [AS-EJB default-resource-principal] :  name cannot be an empty string"));
                    } else {
                        this.addGoodDetails(result, compName);
                        result.passed(smh.getLocalString(this.getClass().getName() + ".passed1", "PASSED [AS-EJB default-resource-principal] : name is {0}", new Object[]{name}));
                    }
                    String password = this.getXPathValue("sun-ejb-jar/enterprise-beans/cmp-resource/default-resource-principal/password");
                    if (password == null || password.length() == 0) {
                        this.oneWarning = true;
                        this.addWarningDetails(result, compName);
                        result.warning(smh.getLocalString(this.getClass().getName() + ".warning1", "WARNING [AS-EJB default-resource-principal] : password is an empty string"));
                    } else {
                        this.addGoodDetails(result, compName);
                        result.passed(smh.getLocalString(this.getClass().getName() + ".passed2", "PASSED [AS-EJB default-resource-principal] : password is  {0}", new Object[]{password}));
                    }
                } else {
                    this.addNaDetails(result, compName);
                    result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "NOT APPLICABLE [AS-EJB cmp-resource] : default-resource-principal Element not defined"));
                }
                Float specVer = this.getRuntimeSpecVersion();
                if (Float.compare(specVer.floatValue(), new Float("2.1").floatValue()) >= 0) {
                    result = this.testProperty("property", result, "sun-ejb-jar/enterprise-beans/cmp-resource/property", compName, descriptor);
                    result = this.testProperty("schema-generator-properties", result, "sun-ejb-jar/enterprise-beans/cmp-resource/schema-generator-properties/property", compName, descriptor);
                }
                if (this.oneFailed) {
                    result.setStatus(1);
                } else if (this.oneWarning) {
                    result.setStatus(2);
                }
            } else {
                this.addNaDetails(result, compName);
                result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable1", "NOT APPLICABLE [AS-EJB enterprise-beans] : cmp-resource element is not defined"));
            }
        }
        catch (Exception ex) {
            this.addErrorDetails(result, compName);
            result.failed(smh.getLocalString(this.getClass().getName() + ".notRun", "NOT RUN [AS-EJB cmp] Could not create descriptor Object."));
        }
        return result;
    }

    private Result testProperty(String testFor, Result result, String xpath, ComponentNameConstructor compName, EjbDescriptor descriptor) {
        String name = null;
        String value = null;
        int count = this.getCountNodeSet(xpath);
        if (count > 0) {
            for (int i = 1; i <= count; ++i) {
                name = this.getXPathValue(xpath + "/name");
                if (name == null || name.length() == 0) {
                    this.oneFailed = true;
                    this.addErrorDetails(result, compName);
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed3", "FAILED [AS-EJB cmp-resource {1}] : name cannot be an empty string", new Object[]{descriptor.getName(), testFor}));
                } else {
                    this.addGoodDetails(result, compName);
                    result.passed(smh.getLocalString(this.getClass().getName() + ".passed3", "PASSED [AS-EJB cmp-resource {2}] : name is {1}", new Object[]{descriptor.getName(), name, testFor}));
                }
                value = this.getXPathValue(xpath + "/value");
                if (value == null || value.length() == 0) {
                    this.oneFailed = true;
                    this.addErrorDetails(result, compName);
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed4", "FAILED [AS-EJB cmp-resource {1}] : value cannot be an empty string", new Object[]{descriptor.getName(), testFor}));
                    continue;
                }
                this.addGoodDetails(result, compName);
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed4", "PASSED [AS-EJB cmp-resource {2}] : value is {1}", new Object[]{descriptor.getName(), value, testFor}));
            }
        }
        return result;
    }
}

