/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.runtime;

import com.sun.enterprise.deployment.ResourcePrincipal;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbMessageBeanDescriptor;
import org.glassfish.ejb.deployment.descriptor.runtime.IASEjbExtraDescriptors;
import org.glassfish.ejb.deployment.descriptor.runtime.MdbConnectionFactoryDescriptor;

public class ASEjbMDBConnFactory
extends EjbTest
implements EjbCheck {
    @Override
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        boolean oneFailed = false;
        boolean oneWarn = false;
        try {
            IASEjbExtraDescriptors iasEjbExtraDesc = descriptor.getIASEjbExtraDescriptors();
            MdbConnectionFactoryDescriptor mdbConnFacDesc = iasEjbExtraDesc.getMdbConnectionFactory();
            if (mdbConnFacDesc != null) {
                String jndiName = mdbConnFacDesc.getJndiName();
                if (jndiName == null || jndiName.length() == 0) {
                    oneFailed = true;
                    this.addErrorDetails(result, compName);
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "FAILED [AS-EJB mdb-connection-factory] : jndi-name cannot be an empty string"));
                } else if (jndiName.startsWith("jms/")) {
                    this.addGoodDetails(result, compName);
                    result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "PASSED [AS-EJB mdb-connection-factory] : jndi-name is {0}", new Object[]{jndiName}));
                } else {
                    oneWarn = true;
                    this.addWarningDetails(result, compName);
                    result.warning(smh.getLocalString(this.getClass().getName() + ".warning", "WARNING [AS-EJB mdb-connection-factory] : jndi-name {0} should start with jms/", new Object[]{jndiName}));
                }
                ResourcePrincipal defPrinci = mdbConnFacDesc.getDefaultResourcePrincipal();
                if (defPrinci != null) {
                    String name = defPrinci.getName();
                    if (name == null || name.length() == 0) {
                        oneFailed = true;
                        this.addErrorDetails(result, compName);
                        result.failed(smh.getLocalString(this.getClass().getName() + ".failed1", "FAILED [AS-EJB default-resource-principal] : name cannot be an empty string"));
                    } else {
                        this.addGoodDetails(result, compName);
                        result.passed(smh.getLocalString(this.getClass().getName() + ".passed1", "PASSED [AS-EJB default-resource-principal] : name is {0}", new Object[]{name}));
                    }
                    String password = defPrinci.getPassword();
                    if (password == null || password.length() == 0) {
                        this.addWarningDetails(result, compName);
                        result.warning(smh.getLocalString(this.getClass().getName() + ".warning2", "WARNING [AS-EJB default-resource-principal] : password is an empty string"));
                    } else {
                        this.addGoodDetails(result, compName);
                        result.passed(smh.getLocalString(this.getClass().getName() + ".passed2", "PASSED [AS-EJB default-resource-principal] : password is  {0}", new Object[]{password}));
                    }
                } else {
                    this.addNaDetails(result, compName);
                    result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "NOT APPLICABLE [AS-EJB mdb-connection-factory] : default-resource-prncipal element is not defined"));
                }
            } else if (descriptor instanceof EjbMessageBeanDescriptor) {
                EjbMessageBeanDescriptor mdbDesc;
                boolean failed = false;
                int count = this.getCountNodeSet("sun-ejb-jar/enterprise-beans/ejb[ejb-name=\"" + descriptor.getName() + "\"]/mdb-resource-adapter");
                if (count > 0) {
                    String value = this.getXPathValue("sun-ejb-jar/enterprise-beans/ejb[ejb-name=\"" + descriptor.getName() + "\"]/mdb-resource-adapter/resource-adapter-mid");
                    if (value == null || value.length() == 0) {
                        failed = true;
                    }
                } else {
                    failed = true;
                }
                if (failed && (mdbDesc = (EjbMessageBeanDescriptor)descriptor).hasTopicDest() && mdbDesc.hasDurableSubscription()) {
                    oneFailed = true;
                    this.addErrorDetails(result, compName);
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed2", "FAILED [AS-EJB ejb] : mdb-connection-factory has to be defined for an MDB with destination-type as Topic and subscription-durability as Durable"));
                }
            } else {
                this.addNaDetails(result, compName);
                result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable1", "NOT APPLICABLE [AS-EJB ejb] : mdb-connection-factory element is not defined"));
            }
            if (oneFailed) {
                result.setStatus(1);
            } else if (oneWarn) {
                result.setStatus(2);
            }
        }
        catch (Exception ex) {
            this.addErrorDetails(result, compName);
            result.failed(smh.getLocalString(this.getClass().getName() + ".notRun", "NOT RUN [AS-EJB cmp] Could not create descriptor Object."));
        }
        return result;
    }
}

