/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.elements;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class MethodsExist
extends EjbTest {
    protected Result result = null;
    protected ComponentNameConstructor compName = null;
    private List<Method> methods = null;

    protected void checkMethodStyles(MethodDescriptor methodDescriptor, EjbDescriptor descriptor) {
        if (methodDescriptor.getName().equals("*")) {
            return;
        }
        if (methodDescriptor.getParameterClassNames() == null) {
            this.checkStyle(methodDescriptor, descriptor, true);
        } else {
            this.checkStyle(methodDescriptor, descriptor, false);
        }
    }

    private void checkStyle(MethodDescriptor methodDescriptor, EjbDescriptor descriptor, boolean isCheckStyle2) {
        String methodName = methodDescriptor.getName();
        if (methodDescriptor.getEjbClassSymbol() != null) {
            String endpointIntfName;
            if (methodDescriptor.getEjbClassSymbol().equals("Remote")) {
                HashSet<String> interfaces = new HashSet<String>(descriptor.getRemoteBusinessClassNames());
                if (descriptor.getRemoteClassName() != null) {
                    interfaces.add(descriptor.getRemoteClassName());
                }
                if (!this.contains(methodDescriptor, this.getAllMethods(interfaces), isCheckStyle2)) {
                    this.logFailure(methodName, "remote");
                }
            } else if (methodDescriptor.getEjbClassSymbol().equals("Local")) {
                HashSet<String> interfaces = new HashSet<String>(descriptor.getLocalBusinessClassNames());
                if (descriptor.getLocalClassName() != null) {
                    interfaces.add(descriptor.getLocalClassName());
                }
                if (!this.contains(methodDescriptor, this.getAllMethods(interfaces), isCheckStyle2)) {
                    this.logFailure(methodName, "local");
                }
            } else if (methodDescriptor.getEjbClassSymbol().equals("Home")) {
                if (!this.contains(methodDescriptor, this.getAllMethods(descriptor.getHomeClassName()), isCheckStyle2)) {
                    this.logFailure(methodName, "home");
                }
            } else if (methodDescriptor.getEjbClassSymbol().equals("LocalHome")) {
                if (!this.contains(methodDescriptor, this.getAllMethods(descriptor.getLocalHomeClassName()), isCheckStyle2)) {
                    this.logFailure(methodName, "localhome");
                }
            } else if (methodDescriptor.getEjbClassSymbol().equals("ServiceEndpoint") && !this.contains(methodDescriptor, this.getAllMethods(endpointIntfName = descriptor.getWebServiceEndpointInterfaceName()), isCheckStyle2)) {
                this.logFailure(methodName, "localhome");
            }
        } else if (!this.contains(methodDescriptor, this.getAllMethods(descriptor), true)) {
            this.logFailure(methodDescriptor.getName(), "any of component or home");
        }
    }

    private boolean contains(MethodDescriptor method1, List<Method> methods, boolean isStyle2) {
        for (Method method : methods) {
            if (!(isStyle2 ? method.getName().equals(method1.getName()) : method.getName().equals(method1.getName()) && Arrays.equals(new MethodDescriptor().getParameterClassNamesFor(method, (Class[])method.getParameterTypes()), method1.getParameterClassNames()))) continue;
            return true;
        }
        return false;
    }

    private List<Method> getAllMethods(EjbDescriptor descriptor) {
        if (this.methods != null) {
            return this.methods;
        }
        this.methods = new ArrayList<Method>();
        Set interfaces = descriptor.getLocalBusinessClassNames();
        interfaces.addAll(descriptor.getRemoteBusinessClassNames());
        if (descriptor.getRemoteClassName() != null) {
            interfaces.add(descriptor.getRemoteClassName());
        }
        if (descriptor.getLocalClassName() != null) {
            interfaces.add(descriptor.getLocalClassName());
        }
        if (descriptor.getHomeClassName() != null) {
            interfaces.add(descriptor.getHomeClassName());
        }
        if (descriptor.getLocalHomeClassName() != null) {
            interfaces.add(descriptor.getLocalHomeClassName());
        }
        if (descriptor.getWebServiceEndpointInterfaceName() != null) {
            interfaces.add(descriptor.getWebServiceEndpointInterfaceName());
        }
        for (String intf : interfaces) {
            Class intfClass = this.loadClass(intf);
            if (intfClass == null) continue;
            this.methods.addAll(Arrays.asList(intfClass.getMethods()));
        }
        return this.methods;
    }

    private List<Method> getAllMethods(String intf) {
        Class intfClass = this.loadClass(intf);
        return intfClass == null ? new ArrayList() : Arrays.asList(intfClass.getMethods());
    }

    private List<Method> getAllMethods(Set<String> interfaces) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (String intf : interfaces) {
            Class intfClass = this.loadClass(intf);
            if (intfClass == null) continue;
            methods.addAll(Arrays.asList(intfClass.getMethods()));
        }
        return methods;
    }

    private Class loadClass(String className) {
        Class<?> intfClass = null;
        try {
            intfClass = Class.forName(className, false, this.getVerifierContext().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            this.addErrorDetails(this.result, this.compName);
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Interface class not found. [ {0} ]", new Object[]{className}));
        }
        return intfClass;
    }

    private void logFailure(String msg1, String msg2) {
        this.addErrorDetails(this.result, this.compName);
        this.result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: Method name [ {0} ] not defined in {1} interface.", new Object[]{msg1, msg2}));
    }
}

