/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb;

import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import org.glassfish.ejb.deployment.descriptor.EjbBundleDescriptorImpl;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbEntityDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbSessionDescriptor;

public class LocalInterfaceExposed
extends EjbTest
implements EjbCheck {
    @Override
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        if (!(descriptor instanceof EjbSessionDescriptor) && !(descriptor instanceof EjbEntityDescriptor)) {
            this.addNaDetails(result, compName);
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable1", "Test apply only to session or entity beans."));
            return result;
        }
        EjbBundleDescriptorImpl bundle = descriptor.getEjbBundleDescriptor();
        Iterator iterator = bundle.getEjbs().iterator();
        HashSet<String> localInterfaces = new HashSet<String>();
        while (iterator.hasNext()) {
            EjbDescriptor entity = (EjbDescriptor)iterator.next();
            if (entity.getLocalClassName() != null) {
                localInterfaces.add(entity.getLocalClassName());
            }
            localInterfaces.addAll(entity.getLocalBusinessClassNames());
        }
        ClassLoader jcl = this.getVerifierContext().getClassLoader();
        try {
            HashSet<String> remoteInterfaces = new HashSet<String>();
            if (descriptor.getRemoteClassName() != null) {
                remoteInterfaces.add(descriptor.getRemoteClassName());
            }
            remoteInterfaces.addAll(descriptor.getRemoteBusinessClassNames());
            for (String intf : remoteInterfaces) {
                Class<?> c = Class.forName(intf, false, this.getVerifierContext().getClassLoader());
                Method[] methods = c.getDeclaredMethods();
                for (int i = 0; i < methods.length; ++i) {
                    for (String localIntf : localInterfaces) {
                        Class<?> returnType = methods[i].getReturnType();
                        if (!this.getBaseComponentType(returnType).getName().equals(localIntf) && !this.contains(methods[i].getParameterTypes(), localIntf)) continue;
                        this.addErrorDetails(result, compName);
                        result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error : Local Interface [ {0} ] has been exposed in remote interface [ {1} ]", new Object[]{localIntf, c.getName()}));
                        return result;
                    }
                }
            }
            this.addGoodDetails(result, compName);
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Valid Remote interface."));
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            this.addErrorDetails(result, compName);
            result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: [ {0} ] class not found.", new Object[]{descriptor.getRemoteClassName()}));
        }
        return result;
    }

    private boolean contains(Class[] args, String intf) {
        for (int i = 0; i < args.length; ++i) {
            if (!this.getBaseComponentType(args[i]).getName().equals(intf)) continue;
            return true;
        }
        return false;
    }

    private Class getBaseComponentType(Class cls) {
        if (!cls.isArray()) {
            return cls;
        }
        return this.getBaseComponentType(cls.getComponentType());
    }
}

