/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.connector.messageinflow;

import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.InboundResourceAdapter;
import com.sun.enterprise.deployment.MessageListener;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorCheck;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class CheckActivationSpecJavaBean
extends ConnectorTest
implements ConnectorCheck {
    @Override
    public Result check(ConnectorDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        if (!descriptor.getInBoundDefined()) {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.messageinflow.notApp", "Resource Adapter does not provide inbound communication"));
            return result;
        }
        InboundResourceAdapter ra = descriptor.getInboundResourceAdapter();
        Set msgListeners = ra.getMessageListeners();
        boolean oneFailed = false;
        for (MessageListener msgListener : msgListeners) {
            String impl = msgListener.getActivationSpecClass();
            Class<?> implClass = null;
            try {
                implClass = Class.forName(impl, false, this.getVerifierContext().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.messageinflow.nonexist", "Error: The class [ {0} ] as defined under activationspec-class in the deployment descriptor does not exist", new Object[]{impl}));
                return result;
            }
            Set configProps = msgListener.getConfigProperties();
            Iterator propIter = configProps.iterator();
            BeanInfo bi = null;
            try {
                bi = Introspector.getBeanInfo(implClass, Object.class);
            }
            catch (IntrospectionException ie) {
                oneFailed = true;
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: The activationspec-class [ {0} ] is not JavaBeans compliant", new Object[]{impl}));
                return result;
            }
            PropertyDescriptor[] properties = bi.getPropertyDescriptors();
            Hashtable<String, PropertyDescriptor> props = new Hashtable<String, PropertyDescriptor>();
            for (int i = 0; i < properties.length; ++i) {
                props.put(properties[i].getName(), properties[i]);
            }
            while (propIter.hasNext()) {
                EnvironmentProperty envProp = (EnvironmentProperty)propIter.next();
                String name = envProp.getName();
                String type = envProp.getType();
                PropertyDescriptor propDesc = (PropertyDescriptor)props.get(name.substring(0, 1).toLowerCase() + name.substring(1));
                if (propDesc != null) {
                    if (propDesc.getReadMethod() != null && propDesc.getWriteMethod() != null) continue;
                    oneFailed = true;
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed1", "Error: The activationspec-class [ {0} ] does not provide accessor methods for [ {1} ].", new Object[]{impl, name}));
                    return result;
                }
                oneFailed = true;
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed1", "Error: The activationspec-class [ {0} ] does not provide accessor methods for [ {1} ].", new Object[]{impl, name}));
                return result;
            }
        }
        if (!oneFailed) {
            result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Success: Each activationspec-class is a Java Bean"));
        }
        return result;
    }
}

