/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.connector.managed;

import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.OutboundResourceAdapter;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorCheck;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest;
import java.util.Set;

public class CheckConnectionFactoryImplSerializable
extends ConnectorTest
implements ConnectorCheck {
    @Override
    public Result check(ConnectorDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        if (!descriptor.getOutBoundDefined()) {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.managed.notApplicableForInboundRA", "Resource Adapter does not provide outbound communication"));
            return result;
        }
        OutboundResourceAdapter outboundRA = descriptor.getOutboundResourceAdapter();
        if (outboundRA == null) {
            return null;
        }
        boolean oneFailed = false;
        Set connDefs = outboundRA.getConnectionDefs();
        for (ConnectionDefDescriptor connDefDesc : connDefs) {
            String connectionImpl = connDefDesc.getConnectionFactoryImpl();
            Class<?> implClass = null;
            try {
                implClass = Class.forName(connectionImpl, false, this.getVerifierContext().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".nonexist", "Error: The class [ {0} ] as defined under connectionfactory-impl-class in the deployment descriptor does not exist", new Object[]{connectionImpl}));
                return result;
            }
            if (CheckConnectionFactoryImplSerializable.isImplementorOf(implClass, "java.io.Serializable")) continue;
            oneFailed = true;
            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: connectionfactory-impl-class [ {0} ] does not implement java.io.Serializable", new Object[]{implClass.getName()}));
            return result;
        }
        if (!oneFailed) {
            result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Success: all connectionfactory-impl-class implement java.io.Serializable"));
        }
        return result;
    }
}

