/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.connector.cci;

import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.OutboundResourceAdapter;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.VerifierTestContext;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest;
import java.util.Set;

public abstract class CCITest
extends ConnectorTest {
    protected boolean isCCIImplemented(ConnectorDescriptor descriptor, Result result) {
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        OutboundResourceAdapter outboundRA = descriptor.getOutboundResourceAdapter();
        if (outboundRA == null) {
            return false;
        }
        Set connDefs = outboundRA.getConnectionDefs();
        for (ConnectionDefDescriptor connDefDesc : connDefs) {
            String intf = connDefDesc.getConnectionFactoryIntf();
            Class<?> implClass = null;
            try {
                implClass = Class.forName(intf, false, this.getVerifierContext().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest.isClassLoadable.failed", "The class [ {0} ] is not contained in the archive file", new Object[]{intf}));
                continue;
            }
            if (!CCITest.isImplementorOf(implClass, "javax.resource.cci.ConnectionFactory")) continue;
            return true;
        }
        return false;
    }

    protected String getConnectionInterface(ConnectorDescriptor descriptor, Result result) {
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        OutboundResourceAdapter outboundRA = descriptor.getOutboundResourceAdapter();
        if (outboundRA == null) {
            return null;
        }
        Set connDefs = outboundRA.getConnectionDefs();
        for (ConnectionDefDescriptor connDefDesc : connDefs) {
            String intf = connDefDesc.getConnectionIntf();
            VerifierTestContext context = this.getVerifierContext();
            ClassLoader jcl = context.getRarClassLoader();
            Class<?> intfClass = null;
            try {
                intfClass = Class.forName(intf, false, this.getVerifierContext().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest.isClassLoadable.failed", "The class [ {0} ] is not contained in the archive file", new Object[]{intf}));
                continue;
            }
            if (!CCITest.isImplementorOf(intfClass, "javax.resource.cci.Connection")) continue;
            return intf;
        }
        return null;
    }
}

