/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.appclient;

import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClosureCompiler;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.appclient.AppClientCheck;
import com.sun.enterprise.tools.verifier.tests.appclient.AppClientTest;
import com.sun.enterprise.tools.verifier.tests.util.ArchiveClassesLoadableHelper;
import java.util.Enumeration;

public class AppClientArchiveClassesLoadable
extends AppClientTest
implements AppClientCheck {
    @Override
    public Result check(ApplicationClientDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        String archiveUri = this.getAbstractArchiveUri(descriptor);
        boolean allPassed = true;
        FileArchive arch = null;
        Enumeration entries = null;
        ClosureCompiler closureCompiler = this.getVerifierContext().getClosureCompiler();
        try {
            String uri = this.getAbstractArchiveUri(descriptor);
            arch = new FileArchive();
            arch.open(uri);
            entries = arch.entries();
            arch.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            result.failed(smh.getLocalString(this.getClass().getName() + ".exception", "Error: [ {0} ] exception while loading the archive [ {1} ].", new Object[]{e, descriptor.getName()}));
            return result;
        }
        while (entries.hasMoreElements()) {
            String name = null;
            Object entry = entries.nextElement();
            name = (String)entry;
            if (!name.endsWith(".class")) continue;
            String className = name.substring(0, name.length() - ".class".length()).replace('/', '.');
            boolean status = closureCompiler.buildClosure(className);
            allPassed = status && allPassed;
        }
        if (allPassed) {
            result.setStatus(0);
            this.addGoodDetails(result, compName);
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "All the classes are loadable within [ {0} ] without any linkage error.", new Object[]{archiveUri}));
        } else {
            result.setStatus(1);
            this.addErrorDetails(result, compName);
            result.addErrorDetails(ArchiveClassesLoadableHelper.getFailedResult(closureCompiler));
            result.addErrorDetails(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.loadableError", "Please either bundle the above mentioned classes in the application or use optional packaging support for them."));
        }
        return result;
    }
}

