/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.appclient;

import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.tools.verifier.BaseVerifier;
import com.sun.enterprise.tools.verifier.SpecVersionMapper;
import com.sun.enterprise.tools.verifier.VerifierFrameworkContext;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClassFileLoaderFactory;
import com.sun.enterprise.tools.verifier.apiscan.packaging.ClassPathBuilder;
import com.sun.enterprise.tools.verifier.apiscan.stdapis.AppClientClosureCompiler;
import com.sun.enterprise.tools.verifier.appclient.AppClientCheckMgrImpl;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import org.glassfish.deployment.common.Descriptor;

public class AppClientVerifier
extends BaseVerifier {
    private ApplicationClientDescriptor appclientd = null;
    private String classPath;
    private boolean isASMode = false;

    public AppClientVerifier(VerifierFrameworkContext verifierFrameworkContext, ApplicationClientDescriptor appClientDescriptor) {
        this.verifierFrameworkContext = verifierFrameworkContext;
        this.appclientd = appClientDescriptor;
        this.isASMode = !verifierFrameworkContext.isPortabilityMode();
    }

    @Override
    public void verify() throws Exception {
        if (this.areTestsNotRequired(this.verifierFrameworkContext.isAppClient()) && this.areTestsNotRequired(this.verifierFrameworkContext.isWebServicesClient()) && this.areTestsNotRequired(this.verifierFrameworkContext.isPersistenceUnits())) {
            return;
        }
        this.preVerification();
        this.createClosureCompiler();
        this.verify((Descriptor)this.appclientd, new AppClientCheckMgrImpl(this.verifierFrameworkContext));
    }

    @Override
    public Descriptor getDescriptor() {
        return this.appclientd;
    }

    @Override
    protected ClassLoader createClassLoader() throws IOException {
        return this.appclientd.getClassLoader();
    }

    @Override
    protected String getArchiveUri() {
        return FileUtils.makeFriendlyFilename((String)this.appclientd.getModuleDescriptor().getArchiveUri());
    }

    @Override
    protected String[] getDDString() {
        String[] dd = new String[]{"META-INF/sun-application-client.xml", "META-INF/application-client.xml", "META-INF/glassfish-application-client.xml"};
        return dd;
    }

    @Override
    protected String getClassPath() throws IOException {
        String cp;
        if (this.classPath != null) {
            return this.classPath;
        }
        if (this.isASMode) {
            this.classPath = this.getClassPath(this.verifierFrameworkContext.getClassPath());
            return this.classPath;
        }
        if (!this.appclientd.getModuleDescriptor().isStandalone()) {
            String ear_uri = this.verifierFrameworkContext.getExplodedArchivePath();
            File ear = new File(ear_uri);
            assert (ear.isDirectory());
            String earCP = ClassPathBuilder.buildClassPathForEar(ear);
            String libdir = this.appclientd.getApplication().getLibraryDirectory();
            if (libdir != null) {
                earCP = this.getLibdirClasspath(ear_uri, libdir) + earCP;
            }
            String module_uri = this.appclientd.getModuleDescriptor().getArchiveUri();
            File module = new File(module_uri);
            assert (module.isFile() && !module.isAbsolute());
            File explodedModuleDir = new File(ear_uri, FileUtils.makeFriendlyFilename((String)module_uri));
            String moduleCP = ClassPathBuilder.buildClassPathForJar(explodedModuleDir);
            cp = moduleCP + File.pathSeparator + earCP;
        } else {
            String module_uri = this.verifierFrameworkContext.getExplodedArchivePath();
            File module = new File(module_uri);
            assert (module.isDirectory() && module.isAbsolute());
            cp = ClassPathBuilder.buildClassPathForJar(module);
        }
        this.classPath = cp;
        return this.classPath;
    }

    protected void createClosureCompiler() throws IOException {
        String specVer = SpecVersionMapper.getAppClientVersion(this.verifierFrameworkContext.getJavaEEVersion());
        Object arg = this.isASMode ? this.appclientd.getClassLoader() : this.getClassPath();
        AppClientClosureCompiler cc = new AppClientClosureCompiler(specVer, ClassFileLoaderFactory.newInstance(new Object[]{arg}));
        this.context.setClosureCompiler(cc);
    }
}

