/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier;

import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.tools.verifier.CheckMgr;
import com.sun.enterprise.tools.verifier.VerifierFrameworkContext;
import com.sun.enterprise.tools.verifier.VerifierTestContext;
import com.sun.enterprise.tools.verifier.util.LogDomains;
import com.sun.enterprise.tools.verifier.util.XMLValidationHandler;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.glassfish.deployment.common.Descriptor;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class BaseVerifier {
    protected Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.avk.tools.verifier");
    protected VerifierFrameworkContext verifierFrameworkContext = null;
    protected VerifierTestContext context = null;

    public abstract void verify() throws Exception;

    public abstract Descriptor getDescriptor();

    protected abstract ClassLoader createClassLoader() throws IOException;

    protected abstract String getArchiveUri();

    protected abstract String getClassPath() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createDocumentObject(Descriptor descriptor) throws IOException, ParserConfigurationException, SAXException {
        BundleDescriptor bundleDesc;
        InputStream is = null;
        InputSource source = null;
        String archBase = new File(this.context.getAbstractArchive().getURI()).getAbsolutePath();
        String uri = null;
        uri = descriptor instanceof Application ? archBase : ((bundleDesc = (BundleDescriptor)BundleDescriptor.class.cast(descriptor)).getModuleDescriptor().isStandalone() ? archBase : archBase + File.separator + this.getArchiveUri());
        String[] dd = this.getDDString();
        for (int i = 0; i < dd.length; ++i) {
            try {
                is = this.getInputStreamFromAbstractArchive(uri, dd[i]);
                if (is == null) continue;
                source = new InputSource(is);
                this.createDOMObject(source, dd[i]);
                is.close();
                continue;
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    protected boolean areTestsNotRequired(boolean isModuleGivenInPartiotioningArgs) {
        return this.verifierFrameworkContext.isPartition() && !isModuleGivenInPartiotioningArgs;
    }

    protected void preVerification() throws Exception {
        this.logger.log(Level.INFO, "Verifying: [ " + this.getArchiveUri() + " ]");
        ClassLoader loader = this.createClassLoader();
        this.context = new VerifierTestContext(loader);
        this.context.setAppserverMode(!this.verifierFrameworkContext.isPortabilityMode());
        this.context.setAbstractArchive(this.verifierFrameworkContext.getArchive());
        this.context.setClassPath(this.getClassPath());
        this.logger.log(Level.FINE, "Using CLASSPATH: " + this.getClassPath());
    }

    protected void verify(Descriptor descriptor, CheckMgr checkMgrImpl) throws Exception {
        this.createDocumentObject(descriptor);
        checkMgrImpl.setVerifierContext(this.context);
        checkMgrImpl.check(descriptor);
        this.logger.log(Level.FINE, this.getClass().getName() + ".debug.endStaticVerification");
    }

    protected void createDOMObject(InputSource source, String dd) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        XMLValidationHandler dh = new XMLValidationHandler(false);
        builder.setEntityResolver(dh);
        Document document = builder.parse(source);
        if (dd.indexOf("sun-") < 0) {
            if (dd.indexOf("webservices") < 0) {
                this.context.setDocument(document);
            } else {
                this.context.setWebServiceDocument(document);
            }
        } else {
            this.context.setRuntimeDocument(document);
        }
    }

    protected abstract String[] getDDString();

    protected InputStream getInputStreamFromAbstractArchive(String uri, String ddName) throws IOException {
        FileArchive arch = new FileArchive();
        arch.open(new File(uri).toURI());
        InputStream deploymentEntry = arch.getEntry(ddName);
        return deploymentEntry;
    }

    protected String getLibdirClasspath(String appRoot, String libdirPath) throws IOException {
        StringBuilder classpath = new StringBuilder();
        libdirPath = libdirPath.replace('/', File.separatorChar);
        List<String> jars = this.getAllJars(new File(appRoot, libdirPath));
        for (String s : jars) {
            classpath.append(s);
            classpath.append(File.pathSeparator);
        }
        return classpath.toString();
    }

    private List<String> getAllJars(File file) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        if (file.isDirectory() || file.canRead()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File jar = files[i];
                if (!FileUtils.isJar((File)jar)) continue;
                list.add(jar.getCanonicalPath());
            }
        }
        return list;
    }

    protected String getClassPath(List<String> classPath) {
        if (classPath == null) {
            return "";
        }
        StringBuilder cp = new StringBuilder("");
        for (int i = 0; i < classPath.size(); ++i) {
            cp.append(classPath.get(i));
            cp.append(File.pathSeparator);
        }
        return cp.toString();
    }
}

