/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.webservices;

import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServiceHandler;
import com.sun.enterprise.deployment.WebServiceHandlerChain;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.webservices.WSCheck;
import com.sun.enterprise.tools.verifier.tests.webservices.WSTest;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.ws.handler.Handler;

public class HandlerChainClassCheck
extends WSTest
implements WSCheck {
    @Override
    public Result check(WebServiceEndpoint descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        LinkedList handlerChain = descriptor.getHandlerChain();
        Iterator it = handlerChain.iterator();
        while (it.hasNext()) {
            List handlers = ((WebServiceHandlerChain)it.next()).getHandlers();
            Iterator itr = handlers.iterator();
            while (itr.hasNext()) {
                String hClass = ((WebServiceHandler)itr.next()).getHandlerClass();
                try {
                    Class<?> cl = Class.forName(hClass, false, this.getVerifierContext().getClassLoader());
                    if (Handler.class.isAssignableFrom(cl)) continue;
                    this.addErrorDetails(result, compName);
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Handler Class [{0}] does not implement javax.xml.ws.handler.Handler Interface", new Object[]{hClass}));
                }
                catch (ClassNotFoundException e) {
                    this.addErrorDetails(result, compName);
                    result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.clfailed", "The [{0}] Class [{1}] could not be Loaded", new Object[]{"Handler Class", hClass}));
                }
            }
        }
        if (result.getStatus() != 1) {
            this.addGoodDetails(result, compName);
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed1", "Handler chains, if any, are defined properly"));
        }
        return result;
    }
}

