/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web.runtime;

import com.sun.enterprise.deployment.ResourceEnvReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.util.Set;

public class ASResourceEnvRef
extends WebTest
implements WebCheck {
    @Override
    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        boolean oneFailed = false;
        boolean notApp = false;
        try {
            Set envRefs = descriptor.getResourceEnvReferenceDescriptors();
            if (envRefs != null && envRefs.size() > 0) {
                for (ResourceEnvReferenceDescriptor envRef : envRefs) {
                    String resName = envRef.getName();
                    if (this.validResEnvRefName(resName, descriptor)) {
                        this.addGoodDetails(result, compName);
                        result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "PASSED [AS-WEB sun-web-app] resource-env-ref [ {0} ] properly defined in the war file.", new Object[]{resName}));
                        continue;
                    }
                    oneFailed = true;
                    this.addErrorDetails(result, compName);
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "FAILED [AS-WEB sun-web-app] resource-env-ref name [ {0} ] is not valid, either empty or not defined in web.xml.", new Object[]{resName}));
                }
            } else {
                notApp = true;
                this.addNaDetails(result, compName);
                result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "NOT APPLICABLE [AS-WEB sun-web-app] resource-env-ref element not defined in the web archive [ {0} ].", new Object[]{descriptor.getName()}));
            }
            if (oneFailed) {
                result.setStatus(1);
            } else if (notApp) {
                result.setStatus(3);
            } else {
                result.setStatus(0);
                this.addGoodDetails(result, compName);
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed2", "PASSED [AS-WEB sun-web-app] resource-env-ref element(s) are valid within the web archive [ {0} ].", new Object[]{descriptor.getName()}));
            }
        }
        catch (Exception ex) {
            oneFailed = true;
            this.addErrorDetails(result, compName);
            result.failed(smh.getLocalString(this.getClass().getName() + ".failed2", "FAILED [AS-WEB resource-env-ref] Could not create the resource-env-ref"));
        }
        return result;
    }

    boolean validResEnvRefName(String name, WebBundleDescriptor descriptor) {
        boolean valid = true;
        if (name != null && name.length() != 0) {
            try {
                descriptor.getResourceEnvReferenceByName(name);
            }
            catch (IllegalArgumentException e) {
                valid = false;
            }
        } else {
            valid = false;
        }
        return valid;
    }
}

