/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public abstract class URLPatternUnique
extends WebTest
implements WebCheck {
    @Override
    public Result check(WebBundleDescriptor descriptor) {
        boolean na = true;
        boolean warning = false;
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        result.addWarningDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
        HashSet<String> urlPatterns = new HashSet<String>();
        Iterator iter = this.getUrlPatterns(descriptor).iterator();
        while (iter.hasNext()) {
            na = false;
            String urlPattern = (String)iter.next();
            if (urlPatterns.add(urlPattern)) continue;
            warning = true;
            result.setStatus(2);
            result.addWarningDetails(smh.getLocalString(this.getClass().getName() + ".warning", "url-pattern [ {0} ] already exists in web archive [ {1} ]", new Object[]{urlPattern, descriptor.getName()}));
        }
        if (na) {
            result.setStatus(3);
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.addNaDetails(smh.getLocalString(this.getClass().getName() + ".notApplicable", "There is no url-pattern element within the web archive [ {0} ]", new Object[]{descriptor.getName()}));
        } else if (!warning) {
            result.passed(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "All the url-patterns are unique within the web archive [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }

    protected abstract Collection getUrlPatterns(WebBundleDescriptor var1);
}

