/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.homeintf;

import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbUtils;
import java.lang.reflect.Method;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbEntityDescriptor;

public class HomeMethodException
extends EjbTest
implements EjbCheck {
    Result result = null;
    ComponentNameConstructor compName = null;

    @Override
    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        this.compName = this.getVerifierContext().getComponentNameConstructor();
        if (descriptor instanceof EjbSessionDescriptor || descriptor instanceof EjbEntityDescriptor) {
            if (descriptor.getHomeClassName() != null && !"".equals(descriptor.getHomeClassName())) {
                this.commonToBothInterfaces(descriptor.getHomeClassName(), descriptor);
            }
            if (descriptor.getLocalHomeClassName() != null && !"".equals(descriptor.getLocalHomeClassName())) {
                this.commonToBothInterfaces(descriptor.getLocalHomeClassName(), descriptor);
            }
        }
        if (this.result.getStatus() != 1 && this.result.getStatus() != 2) {
            this.addGoodDetails(this.result, this.compName);
            this.result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Valid Home method(s)."));
        }
        return this.result;
    }

    private void commonToBothInterfaces(String home, EjbDescriptor descriptor) {
        try {
            ClassLoader jcl = this.getVerifierContext().getClassLoader();
            Class<?> rc = Class.forName(home, false, jcl);
            for (Method homeMethod : rc.getMethods()) {
                if (homeMethod.getDeclaringClass().getName().equals("javax.ejb.EJBHome") || homeMethod.getDeclaringClass().getName().equals("javax.ejb.EJBLocalHome") || homeMethod.getName().startsWith("create") || homeMethod.getName().startsWith("find") || homeMethod.getName().startsWith("remove")) continue;
                Class<?> beanClass = Class.forName(descriptor.getEjbClassName(), false, jcl);
                for (Method method : beanClass.getMethods()) {
                    Class[] exceptions;
                    String methodName = "ejbHome" + Character.toUpperCase(homeMethod.getName().charAt(0)) + homeMethod.getName().substring(1);
                    if (!method.getName().equals(methodName) || !EjbUtils.isValidRemoteException(exceptions = method.getExceptionTypes())) continue;
                    this.addWarningDetails(this.result, this.compName);
                    this.result.warning(smh.getLocalString(this.getClass().getName() + ".warning", "Error: Compatibility Note:\n A public Home method [ {0} ] was found, but\n EJB 1.0 allowed the 'ejbHome' methods to throw the \n java.rmi.RemoteException to indicate a non-application\n exception. This practice is deprecated in EJB 1.1\n ---an EJB 1.1 compliant enterprise bean should\n throw the javax.ejb.EJBException or another \n RuntimeException to indicate non-application exceptions\n to the Container. ", new Object[]{method.getName()}));
                }
            }
        }
        catch (Exception e) {
            Verifier.debug(e);
            this.addErrorDetails(this.result, this.compName);
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Remote interface [ {0} ] or bean class [ {1} ] does not exist or is not loadable within bean [ {2} ].", new Object[]{home, descriptor.getEjbClassName(), descriptor.getName()}));
        }
    }
}

