/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.findermethod;

import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.VerifierTestContext;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbEntityDescriptor;

public class HomeInterfaceFindMethodMatch
extends EjbTest
implements EjbCheck {
    Result result = null;
    ComponentNameConstructor compName = null;

    @Override
    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        this.compName = this.getVerifierContext().getComponentNameConstructor();
        if (descriptor instanceof EjbEntityDescriptor && ((EjbEntityDescriptor)descriptor).getPersistenceType().equals("Bean")) {
            if (descriptor.getHomeClassName() != null && !"".equals(descriptor.getHomeClassName())) {
                this.commonToBothInterfaces(descriptor.getHomeClassName(), descriptor.getRemoteClassName(), descriptor);
            }
            if (descriptor.getLocalHomeClassName() != null && !"".equals(descriptor.getLocalHomeClassName())) {
                this.commonToBothInterfaces(descriptor.getLocalHomeClassName(), descriptor.getLocalClassName(), descriptor);
            }
        } else {
            this.addNaDetails(this.result, this.compName);
            this.result.notApplicable("This test is only applicable entity beans with bean managed persistence.");
        }
        return this.result;
    }

    private void commonToBothInterfaces(String home, String remote, EjbDescriptor descriptor) {
        int ejbFinderMethodLoopCounter = 0;
        try {
            VerifierTestContext context = this.getVerifierContext();
            ClassLoader jcl = context.getClassLoader();
            Class<?> homeInterfaceClass = Class.forName(home, false, this.getVerifierContext().getClassLoader());
            Class<?> remoteInterfaceClass = Class.forName(remote, false, this.getVerifierContext().getClassLoader());
            Class<?> EJBClass = Class.forName(descriptor.getEjbClassName(), false, this.getVerifierContext().getClassLoader());
            Method[] homeInterfaceMethods = homeInterfaceClass.getMethods();
            Method[] ejbFinderMethods = EJBClass.getMethods();
            for (int i = 0; i < homeInterfaceMethods.length; ++i) {
                int z;
                if (!homeInterfaceMethods[i].getName().startsWith("find")) continue;
                for (z = 0; z < ejbFinderMethods.length; ++z) {
                    if (!ejbFinderMethods[z].getName().startsWith("ejbFind") || !homeInterfaceMethods[i].getName().toUpperCase().equals(ejbFinderMethods[z].getName().toUpperCase().substring(3))) continue;
                    Object[] methodParameterTypes = homeInterfaceMethods[i].getParameterTypes();
                    Object[] ejbFinderMethodParameterTypes = ejbFinderMethods[z].getParameterTypes();
                    boolean returnTypeMatch = this.checkReturnType(homeInterfaceMethods[i], ejbFinderMethods[z], remoteInterfaceClass, descriptor);
                    if (!returnTypeMatch) {
                        this.addErrorDetails(this.result, this.compName);
                        this.result.failed(smh.getLocalString(this.getClass().getName() + ".failReturnType", "For Home Interface [ {0} ] Method [ {1} ] return type [ {2} ] ", new Object[]{homeInterfaceClass.getName(), homeInterfaceMethods[i].getName(), homeInterfaceMethods[i].getReturnType().getName()}));
                        this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failReturnType1", "Error: does not match with return type [ {0} ] of corresponding ejbFind<METHOD>(...).", new Object[]{ejbFinderMethods[z].getReturnType().getName()}));
                    }
                    if (!Arrays.equals(methodParameterTypes, ejbFinderMethodParameterTypes)) {
                        this.addErrorDetails(this.result, this.compName);
                        this.result.failed(smh.getLocalString(this.getClass().getName() + ".debug1", "For Home Interface [ {0} ] Method [ {1} ]", new Object[]{homeInterfaceClass.getName(), homeInterfaceMethods[i].getName()}));
                        this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: A corresponding [ {0} ] method was found, but the parameters did not match.", new Object[]{"ejb" + homeInterfaceMethods[i].getName().toUpperCase().substring(0, 1) + homeInterfaceMethods[i].getName().substring(1)}));
                    }
                    ejbFinderMethodLoopCounter = z;
                    break;
                }
                if (z == ejbFinderMethods.length) {
                    this.addErrorDetails(this.result, this.compName);
                    this.result.failed(smh.getLocalString(this.getClass().getName() + ".debug1", "For Home Interface [ {0} ] Method [ {1} ]", new Object[]{homeInterfaceClass.getName(), homeInterfaceMethods[i].getName()}));
                    this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed1", "Error: No corresponding ejbFind<METHOD>(...)  method was found."));
                }
                if (this.result.getStatus() == 1) continue;
                this.addGoodDetails(this.result, this.compName);
                this.result.passed(smh.getLocalString(this.getClass().getName() + ".debug1", "For Home Interface [ {0} ] Method [ {1} ]", new Object[]{homeInterfaceClass.getName(), homeInterfaceMethods[i].getName()}));
                this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "The corresponding [ {0} ] method with matching parameters was found.", new Object[]{ejbFinderMethods[ejbFinderMethodLoopCounter].getName()}));
            }
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Home interface [ {0} ] or EJB Class [ {1} ] does not exist or is not loadable.", new Object[]{descriptor.getHomeClassName(), descriptor.getEjbClassName()}));
        }
    }

    private boolean checkReturnType(Method homeFinderMethod, Method beanFinderMethod, Class remote, EjbDescriptor descriptor) {
        Class<?> homeMethodtype = homeFinderMethod.getReturnType();
        Class<?> beanMethodType = beanFinderMethod.getReturnType();
        if (homeMethodtype.getName().equals(remote.getName())) {
            return beanMethodType.getName().equals(((EjbEntityDescriptor)descriptor).getPrimaryKeyClassName());
        }
        return homeMethodtype.getName().equals(beanMethodType.getName());
    }
}

