/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.ejbfindermethod;

import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.VerifierTestContext;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Method;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbEntityDescriptor;

public class EjbFinderMethodReturn
extends EjbTest
implements EjbCheck {
    @Override
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        if (descriptor instanceof EjbEntityDescriptor) {
            String persistence = ((EjbEntityDescriptor)descriptor).getPersistenceType();
            if ("Bean".equals(persistence)) {
                boolean ejbFindMethodFound = false;
                boolean returnValueValid = false;
                boolean oneFailed = false;
                boolean oneWarning = false;
                boolean findMethodModifiers = false;
                int foundAtLeastOne = 0;
                try {
                    VerifierTestContext context = this.getVerifierContext();
                    ClassLoader jcl = context.getClassLoader();
                    Class<?> EJBClass = Class.forName(descriptor.getEjbClassName(), false, this.getVerifierContext().getClassLoader());
                    do {
                        Method[] ejbFinderMethods = EJBClass.getDeclaredMethods();
                        String primaryKeyType = ((EjbEntityDescriptor)descriptor).getPrimaryKeyClassName();
                        for (int j = 0; j < ejbFinderMethods.length; ++j) {
                            returnValueValid = false;
                            if (!ejbFinderMethods[j].getName().startsWith("ejbFind")) continue;
                            Class<?> returnByPrimaryKeyValue = ejbFinderMethods[j].getReturnType();
                            ejbFindMethodFound = true;
                            ++foundAtLeastOne;
                            if (returnByPrimaryKeyValue.getName().equals(primaryKeyType) || returnByPrimaryKeyValue.getName().equals("java.util.Collection") || returnByPrimaryKeyValue.getName().equals("java.util.Enumeration")) {
                                returnValueValid = true;
                            }
                            if (ejbFindMethodFound && returnValueValid) {
                                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                                result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For EJB Class [ {0} ] Finder Method [ {1} ]", new Object[]{EJBClass.getName(), ejbFinderMethods[j].getName()}));
                                result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "An [ {0} ] method was found with valid return type.", new Object[]{ejbFinderMethods[j].getName()}));
                                continue;
                            }
                            if (!ejbFindMethodFound || returnValueValid) continue;
                            if (primaryKeyType.equals("java.lang.Object")) {
                                oneWarning = true;
                                result.addWarningDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                                result.addWarningDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For EJB Class [ {0} ] Finder Method [ {1} ]", new Object[]{EJBClass.getName(), ejbFinderMethods[j].getName()}));
                                result.addWarningDetails(smh.getLocalString(this.getClass().getName() + ".warning", "Warning: An [ {0} ] method was found, but [ {1} ] method has [ {2} ] return type.   Deployment descriptor primary key type is [ {3} ]. Definition of the primary key type is deferred to deployment time ?", new Object[]{ejbFinderMethods[j].getName(), ejbFinderMethods[j].getName(), ejbFinderMethods[j].getReturnType().getName(), primaryKeyType}));
                                continue;
                            }
                            oneFailed = true;
                            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                            result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For EJB Class [ {0} ] Finder Method [ {1} ]", new Object[]{EJBClass.getName(), ejbFinderMethods[j].getName()}));
                            result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: An [ {0} ] method was found, but [ {1} ] return type must be the enterprise Bean's primary key type, or an EJB primary key collection .", new Object[]{ejbFinderMethods[j].getName(), ejbFinderMethods[j].getName()}));
                        }
                    } while ((EJBClass = EJBClass.getSuperclass()) != null && foundAtLeastOne == 0);
                    if (foundAtLeastOne == 0) {
                        result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                        result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable1", "[ {0} ] does not declare any ejbFind<METHOD>(...) methods.", new Object[]{descriptor.getEjbClassName()}));
                    }
                }
                catch (ClassNotFoundException e) {
                    Verifier.debug(e);
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: EJB Class [ {1} ] does not exist or is not loadable.", new Object[]{descriptor.getEjbClassName()}));
                    oneFailed = true;
                }
                if (oneFailed) {
                    result.setStatus(1);
                } else if (foundAtLeastOne == 0) {
                    result.setStatus(3);
                } else if (oneWarning) {
                    result.setStatus(2);
                } else {
                    result.setStatus(0);
                }
                return result;
            }
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable2", "Expected [ {0} ] managed persistence, but [ {1} ] bean has [ {2} ] managed persistence.", new Object[]{"Bean", descriptor.getName(), persistence}));
            return result;
        }
        result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
        result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Entity", "Session"}));
        return result;
    }
}

