/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2;

import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.glassfish.ejb.deployment.descriptor.EjbCMPEntityDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbEntityDescriptor;

public abstract class CMPTest
extends EjbTest {
    protected abstract Result check(EjbCMPEntityDescriptor var1);

    @Override
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        if (descriptor instanceof EjbEntityDescriptor) {
            String persistentType = ((EjbEntityDescriptor)descriptor).getPersistenceType();
            if ("Container".equals(persistentType)) {
                if (((EjbCMPEntityDescriptor)descriptor).getCMPVersion() < 2) {
                    result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.CMPTest.notApplicable3", "Test do not apply to this cmp-version of container managed persistence EJBs"));
                    return result;
                }
                return this.check((EjbCMPEntityDescriptor)descriptor);
            }
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.CMPTest.notApplicable2", "Test do not apply to EJB declared with persistence type [ {0} ]", new Object[]{persistentType}));
            return result;
        }
        result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
        result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.CMPTest.notApplicable1", "Test do not apply to non entity EJB "));
        return result;
    }

    public static boolean isFieldAbstract(String fieldName, Class c, Result result) {
        Class savedClass = c;
        boolean foundField = false;
        do {
            try {
                Field f = c.getDeclaredField(fieldName);
                foundField = true;
                result.addErrorDetails(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.CMPTest.isFieldDeclared.failed", "Error: [ {0} ] field is declared in the class [ {1} ]", new Object[]{fieldName, c.getName()}));
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        } while ((c = c.getSuperclass()) != null && !foundField);
        if (!foundField) {
            result.addGoodDetails(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.CMPTest.isFieldDeclared.success", "[ {0} ] field is not declared in the class [ {1} ]", new Object[]{fieldName, savedClass.getName()}));
            return true;
        }
        return false;
    }

    public static boolean isAccessorDeclared(String fieldName, Class fieldType, Class c, Result result) {
        String getMethodName = "get" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
        String setMethodName = "set" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
        Method getMethod = CMPTest.getMethod(c, getMethodName, null);
        if (getMethod != null) {
            if (fieldType != null && !fieldType.getName().equals(getMethod.getReturnType().getName())) {
                result.addErrorDetails(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.CMPTest.isAccessorDeclared.failed1", "Error : [ {0} ] field accessor method has the wrong return type [ {1} ] ", new Object[]{fieldName, getMethod.getReturnType().getName()}));
                return false;
            }
            Class[] parms = new Class[]{getMethod.getReturnType()};
            Method setMethod = CMPTest.getMethod(c, setMethodName, parms);
            if (setMethod != null) {
                if (setMethod.getReturnType().getName().equals("void")) {
                    result.addGoodDetails(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.CMPTest.isAccessorDeclared.success", "[ {0} ] field accessor methods exist and have the correct signaures", new Object[]{fieldName}));
                    return true;
                }
                result.addErrorDetails(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.CMPTest.isAccessorDeclared.failed1", "Error : [ {0} ] field accessor method has the wrong return type [ {1} ] ", new Object[]{fieldName, setMethod.getReturnType().getName()}));
            } else {
                result.addErrorDetails(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.CMPTest.isAccessorDeclared.failed2", "Error : Cannot find accessor [ {0 } ] method for [ {1} ] field ", new Object[]{setMethodName, fieldName}));
            }
        } else {
            result.addErrorDetails(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.CMPTest.isAccessorDeclared.failed2", "Error : Cannot find accessor [ {0} ] method for [ {1} ] field ", new Object[]{getMethodName, fieldName}));
        }
        return false;
    }

    public static boolean startWithLowercasedLetter(String fieldName, Result result) {
        if (Character.isLowerCase(fieldName.charAt(0))) {
            result.addGoodDetails(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.CMPTest.startWithLowercasedLetter.success", "[ {0} ] field first letter is lowercase", new Object[]{fieldName}));
            return true;
        }
        result.addErrorDetails(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.CMPTest.startWithLowercasedLetter.failed", "Error : [ {0} ] field first letter is not lowercase", new Object[]{fieldName}));
        return false;
    }

    public static boolean accessorMethodModifiers(String fieldName, Class c, Result result) {
        int modifiers;
        String getMethodName = "get" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
        String setMethodName = "set" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
        Method getMethod = CMPTest.getMethod(c, getMethodName, null);
        if (getMethod != null && Modifier.isAbstract(modifiers = getMethod.getModifiers()) && (Modifier.isProtected(modifiers) || Modifier.isPublic(modifiers))) {
            Class[] parms = new Class[]{getMethod.getReturnType()};
            Method setMethod = CMPTest.getMethod(c, setMethodName, parms);
            if (setMethod != null && Modifier.isAbstract(modifiers = setMethod.getModifiers()) && (Modifier.isProtected(modifiers) || Modifier.isPublic(modifiers))) {
                result.addGoodDetails(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.CMPTest.accessorMethodModifiers.success", "[ {0} ] field accessor methods are abstract and public or protected", new Object[]{fieldName}));
                return true;
            }
            result.addErrorDetails(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.CMPTest.accessorMethodModifiers.failed", "Error : [ {0} ] accessor method for field [ {1} ] is not abstract and public or protected", new Object[]{setMethodName, fieldName}));
            return false;
        }
        result.addErrorDetails(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.CMPTest.accessorMethodModifiers.failed", "Error : [ {0} ] accessor method for field [ {1} ] is not abstract and public or protected", new Object[]{getMethodName, fieldName}));
        return false;
    }
}

