/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb;

import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;

public class EjbEnvEntryValue
extends EjbTest
implements EjbCheck {
    @Override
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        if (!descriptor.getEnvironmentProperties().isEmpty()) {
            for (EnvironmentProperty nextEnvironmentProperty : descriptor.getEnvironmentProperties()) {
                if (nextEnvironmentProperty.getValue() == null || nextEnvironmentProperty.getValue().length() <= 0 || this.validEnvType(nextEnvironmentProperty)) continue;
                this.addErrorDetails(result, compName);
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: Environment entry name [ {0} ] does not have valid value [ {1} ] for constructor of the specified type [ {2} ] that takes a single String parameter within bean [ {3} ]", new Object[]{nextEnvironmentProperty.getName(), nextEnvironmentProperty.getValue(), nextEnvironmentProperty.getType(), descriptor.getName()}));
            }
        }
        if (result.getStatus() != 1) {
            this.addGoodDetails(result, compName);
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Environment entry name has valid value"));
        }
        return result;
    }

    private boolean validEnvType(EnvironmentProperty nextEnvironmentProperty) {
        block11: {
            try {
                if (nextEnvironmentProperty.getType().equals("java.lang.String")) {
                    new String(nextEnvironmentProperty.getValue());
                    break block11;
                }
                if (nextEnvironmentProperty.getType().equals("java.lang.Integer")) {
                    new Integer(nextEnvironmentProperty.getValue());
                    break block11;
                }
                if (nextEnvironmentProperty.getType().equals("java.lang.Boolean")) {
                    new Boolean(nextEnvironmentProperty.getValue());
                    break block11;
                }
                if (nextEnvironmentProperty.getType().equals("java.lang.Double")) {
                    new Double(nextEnvironmentProperty.getValue());
                    break block11;
                }
                if (nextEnvironmentProperty.getType().equals("java.lang.Character") && nextEnvironmentProperty.getValue().length() == 1) {
                    char c = nextEnvironmentProperty.getValue().charAt(0);
                    new Character(c);
                    break block11;
                }
                if (nextEnvironmentProperty.getType().equals("java.lang.Byte")) {
                    new Byte(nextEnvironmentProperty.getValue());
                    break block11;
                }
                if (nextEnvironmentProperty.getType().equals("java.lang.Short")) {
                    new Short(nextEnvironmentProperty.getValue());
                    break block11;
                }
                if (nextEnvironmentProperty.getType().equals("java.lang.Long")) {
                    new Long(nextEnvironmentProperty.getValue());
                    break block11;
                }
                if (nextEnvironmentProperty.getType().equals("java.lang.Float")) {
                    new Float(nextEnvironmentProperty.getValue());
                    break block11;
                }
                return false;
            }
            catch (Exception ex) {
                Verifier.debug(ex);
                return false;
            }
        }
        return true;
    }
}

