/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.apiscan.classfile;

import com.sun.enterprise.tools.verifier.apiscan.classfile.ClassFile;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClassFileLoader;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClosureCompilerImplBase;
import com.sun.enterprise.tools.verifier.apiscan.classfile.Method;
import com.sun.enterprise.tools.verifier.apiscan.classfile.MethodRef;
import com.sun.enterprise.tools.verifier.apiscan.classfile.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;

class ASMClosureCompilerImpl
extends ClosureCompilerImplBase {
    private Collection<MethodRef> methodReferences = new HashSet<MethodRef>();
    private HashSet<MethodRef> visitedMethods = new HashSet();
    private Stack<MethodRef> callStack = new Stack();
    private boolean result;
    private HashSet<String> closure = new HashSet();
    private Map<String, List<String>> failed = new HashMap<String, List<String>>();
    private static final String myClassName = "ASMClosureCompilerImpl";

    public ASMClosureCompilerImpl(ClassFileLoader loader) {
        super(loader);
    }

    private void resetResult() {
        logger.entering(myClassName, "resetResult", new Object[0]);
        this.result = true;
    }

    private void setResult(boolean newresult) {
        this.result = this.result && newresult;
    }

    private boolean getResult() {
        return this.result;
    }

    @Override
    public boolean buildClosure(String className) {
        logger.entering(myClassName, "buildClosure", className);
        this.resetResult();
        if (this.needToBuildClosure(className)) {
            this.visitedClasses.add(className);
            ClassFile cf = this.load(className);
            if (cf == null) {
                return false;
            }
            Collection<? extends Method> methods = cf.getMethods();
            for (Method method : methods) {
                this.methodReferences.add(method.getSelfReference());
                this.buildClosure(method);
            }
        }
        return this.getResult();
    }

    private void buildClosure(Method m) {
        MethodRef methodReference = m.getSelfReference();
        logger.entering(myClassName, "buildClosure", new Object[]{methodReference});
        this.callStack.push(methodReference);
        if (this.needToBuildClosure(methodReference)) {
            this.visitedMethods.add(methodReference);
            Collection<MethodRef> methodRefs = m.getReferencedMethods();
            this.methodReferences.addAll(methodRefs);
            for (MethodRef nextMethodRef : methodRefs) {
                ClassFile cf;
                if (!this.needToBuildClosure(nextMethodRef) || (cf = this.load(Util.convertToExternalClassName(nextMethodRef.getOwningClassName()))) == null) continue;
                Method nextMethod = cf.getMethod(nextMethodRef);
                if (nextMethod == null) {
                    this.handleFailure(nextMethodRef);
                    continue;
                }
                this.buildClosure(nextMethod);
            }
            for (String className : m.getReferencedClasses()) {
                String externalClassName = Util.convertToExternalClassName(className);
                if (!this.needToBuildClosure(externalClassName)) continue;
                this.load(externalClassName);
            }
        }
        this.callStack.pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClassFile load(String className) {
        logger.entering(myClassName, "load", new Object[]{className});
        ClassFile cf = null;
        try {
            cf = this.loader.load(className);
        }
        catch (IOException e) {
            this.handleFailure(className);
        }
        if (cf != null && this.needToLoad(className)) {
            this.closure.add(className);
            MethodRef clinitMethodRef = new MethodRef(Util.convertToInternalClassName(className), "<clinit>", "()V");
            Method clinitMethod = cf.getMethod(clinitMethodRef);
            try {
                this.callStack.push(clinitMethodRef);
                String superClassName = cf.getNameOfSuperClass();
                if (superClassName != null && this.needToBuildClosure(superClassName)) {
                    this.load(superClassName);
                }
                for (String interfaceClassName : cf.getNamesOfInterfaces()) {
                    if (!this.needToBuildClosure(interfaceClassName)) continue;
                    this.load(interfaceClassName);
                }
            }
            finally {
                this.callStack.pop();
            }
            if (clinitMethod != null) {
                this.methodReferences.add(clinitMethodRef);
                this.buildClosure(clinitMethod);
            }
        }
        logger.exiting(myClassName, "load", cf == null ? "null" : cf.getName());
        return cf;
    }

    private void handleFailure(MethodRef mr) {
        logger.logp(Level.WARNING, myClassName, "handleFailure", this.getClass().getName() + ".exception1", new Object[]{mr.toString()});
    }

    private void handleFailure(String referencedClass) {
        logger.entering(myClassName, "handleFailure", new Object[]{referencedClass});
        this.setResult(false);
        String referencingPath = "";
        try {
            StringBuilder referencingPathBuffer = new StringBuilder();
            for (MethodRef m : this.callStack) {
                if (referencingPathBuffer.length() != 0) {
                    referencingPathBuffer.append("->");
                }
                referencingPathBuffer.append(m);
            }
            referencingPath = referencingPathBuffer.toString();
        }
        catch (EmptyStackException referencingPathBuffer) {
            // empty catch block
        }
        List<String> failedList = this.failed.get(referencingPath);
        if (failedList == null) {
            failedList = new ArrayList<String>();
            this.failed.put(referencingPath, failedList);
        }
        failedList.add(referencedClass);
    }

    @Override
    public Collection getClosure() {
        return Collections.unmodifiableCollection(this.methodReferences);
    }

    @Override
    public Map getFailed() {
        return Collections.unmodifiableMap(this.failed);
    }

    @Override
    public void reset() {
        this.methodReferences.clear();
        this.visitedClasses.clear();
        this.failed.clear();
        this.closure.clear();
    }

    protected boolean needToLoad(String className) {
        return !this.closure.contains(className);
    }

    protected boolean needToBuildClosure(MethodRef methodRef) {
        boolean result = true;
        String owningClassName = methodRef.getOwningClassName();
        if (this.visitedMethods.contains(methodRef)) {
            result = false;
        } else if (this.excludedClasses.contains(owningClassName)) {
            result = false;
        } else if (this.excludedPackages.contains(ASMClosureCompilerImpl.getPackageName(owningClassName))) {
            result = false;
        } else {
            for (String pattern : this.excludedPatterns) {
                if (!owningClassName.startsWith(pattern)) continue;
                result = false;
                break;
            }
        }
        logger.logp(Level.FINEST, myClassName, "needToBuildClosure", methodRef + " " + result);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (logger.isLoggable(Level.FINER)) {
            sb.append("\n<Closure>");
            sb.append("\n\t<ExcludedClasses>");
            Iterator<Object> i = this.excludedClasses.iterator();
            while (i.hasNext()) {
                sb.append("\n\t\t");
                sb.append((String)((Object)i.next()));
            }
            sb.append("\n\t</ExcludedClasses>");
            sb.append("\n\t<ExcludedPackages>");
            i = this.excludedPackages.iterator();
            while (i.hasNext()) {
                sb.append("\n\t\t");
                sb.append((String)((Object)i.next()));
            }
            sb.append("\n\t</ExcludedPackages>");
            sb.append("\n\t<ExcludedPatterns>");
            i = this.excludedPatterns.iterator();
            while (i.hasNext()) {
                sb.append("\n\t\t");
                sb.append((String)((Object)i.next()));
            }
            sb.append("\n\t</ExcludedPatterns>");
            sb.append("\n\t<Methods>");
            for (MethodRef m : this.methodReferences) {
                sb.append("\n\t\t");
                sb.append(m);
            }
            sb.append("\n\t</Methods>");
            sb.append("\n\t<Closure>");
            for (String c : this.closure) {
                sb.append("\n\t\t");
                sb.append(c);
            }
            sb.append("\n\t</Closure>");
        }
        sb.append("\n\t<Failed>");
        for (Map.Entry<String, List<String>> referencingPathToFailedList : this.failed.entrySet()) {
            sb.append("\n\t\t");
            sb.append("<ReferencingPath>");
            sb.append("\n\t\t\t");
            sb.append((Object)referencingPathToFailedList.getKey());
            sb.append("\n\t\t");
            sb.append("</ReferencingPath>");
            sb.append("\n\t\t");
            sb.append("<Classes>");
            Iterator<String> iii = referencingPathToFailedList.getValue().iterator();
            while (iii.hasNext()) {
                sb.append("\n\t\t\t");
                sb.append(iii.next());
            }
            sb.append("\n\t\t");
            sb.append("</Classes>");
        }
        sb.append("\n\t</Failed>");
        if (logger.isLoggable(Level.FINER)) {
            sb.append("\n</Closure>");
        }
        return sb.toString();
    }
}

