/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.io.File;

public class FormLoginPage
extends WebTest
implements WebCheck {
    @Override
    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        if (descriptor.getLoginConfiguration() != null) {
            boolean foundIt = false;
            FileArchive arch = null;
            String formLoginPage = descriptor.getLoginConfiguration().getFormLoginPage();
            if (formLoginPage.length() > 0) {
                try {
                    File flp;
                    String uri = this.getAbstractArchiveUri(descriptor);
                    arch = new FileArchive();
                    arch.open(uri);
                    if (formLoginPage.startsWith("/")) {
                        formLoginPage = formLoginPage.substring(1);
                    }
                    if ((flp = new File(new File(arch.getURI()), formLoginPage)).exists()) {
                        foundIt = true;
                    }
                    flp = null;
                }
                catch (Exception ex) {
                    foundIt = false;
                }
                if (foundIt) {
                    result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "The form-login-page [ {0} ] value does define the location in the web application [ {1} ] where the page can be used for login page can be found.", new Object[]{formLoginPage, descriptor.getName()}));
                } else {
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: The form-login-page [ {0} ] value does not define the location in the web application [ {1} ] where the page to be used for the login page can be found.", new Object[]{formLoginPage, descriptor.getName()}));
                }
            } else {
                result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no form-login-page name elements within this web archive [ {0} ]", new Object[]{descriptor.getName()}));
            }
        } else {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no form-login-page name elements within this web archive [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

