/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.intf.localintf;

import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Method;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;

public class LocalInterfaceRemoteException
extends EjbTest {
    @Override
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        ClassLoader cl = this.getVerifierContext().getClassLoader();
        String localClassName = descriptor.getLocalHomeClassName();
        if (localClassName != null) {
            try {
                Class<?> localHome = Class.forName(localClassName, false, cl);
                Method[] methods = localHome.getMethods();
                for (int i = 0; i < methods.length; ++i) {
                    if (!this.containsRemote(methods[i].getExceptionTypes())) continue;
                    this.addErrorDetails(result, compName);
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Method [ {0} ] throws a RemoteException.", new Object[]{methods[i]}));
                }
            }
            catch (ClassNotFoundException e) {
                Verifier.debug(e);
                this.addErrorDetails(result, compName);
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed1", "LocalHome class [ {0} ] not found.", new Object[]{localClassName}));
            }
        }
        if (result.getStatus() != 1) {
            this.addGoodDetails(result, compName);
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Valid LocalInterface."));
        }
        return result;
    }

    private boolean containsRemote(Class[] exceptions) {
        for (int i = 0; i < exceptions.length; ++i) {
            if (!exceptions[i].getName().equals("java.rmi.RemoteException")) continue;
            return true;
        }
        return false;
    }
}

