/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.ejb30;

import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.util.Set;
import javax.ejb.Local;
import javax.ejb.Remote;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;

public class BusinessIntfAnnotationValue
extends EjbTest {
    private Result result;
    private ComponentNameConstructor compName;
    private Class<Remote> remoteAnn = Remote.class;
    private Class<Local> localAnn = Local.class;

    @Override
    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        this.compName = this.getVerifierContext().getComponentNameConstructor();
        this.testInterfaces(descriptor.getLocalBusinessClassNames(), this.remoteAnn);
        this.testInterfaces(descriptor.getRemoteBusinessClassNames(), this.localAnn);
        if (this.result.getStatus() != 1) {
            this.addGoodDetails(this.result, this.compName);
            this.result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Valid annotations used in business interface(s)."));
        }
        return this.result;
    }

    private void testInterfaces(Set<String> interfaces, Class annot) {
        Class<Remote> cls = annot.equals(this.localAnn) ? this.remoteAnn : this.localAnn;
        for (String intf : interfaces) {
            try {
                Class<?> intfCls = Class.forName(intf, false, this.getVerifierContext().getClassLoader());
                if (intfCls.getAnnotation(annot) == null) continue;
                this.addErrorDetails(this.result, this.compName);
                this.result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "{0} annotation is used in {1} interface [ {2} ].", new Object[]{annot.getSimpleName(), cls.getSimpleName(), intfCls.getName()}));
            }
            catch (ClassNotFoundException e) {}
        }
    }
}

